/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.ItemFilter;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLaserRelayItemWhitelist
extends TileEntityLaserRelayItem
implements IButtonReactor {
    public final IInventory filterInventory;
    public FilterSettings leftFilter = new FilterSettings(0, 12, true, true, false, false, 0, -1000);
    public FilterSettings rightFilter = new FilterSettings(12, 24, true, true, false, false, 0, -2000);
    private ItemStack[] slots = new ItemStack[24];

    public TileEntityLaserRelayItemWhitelist() {
        super("laserRelayItemWhitelist");
        Arrays.fill(this.slots, StackUtil.getNull());
        this.filterInventory = (new IInventory(){
            private TileEntityLaserRelayItemWhitelist tile;

            private IInventory setTile(TileEntityLaserRelayItemWhitelist tile) {
                this.tile = tile;
                return this;
            }

            public String func_70005_c_() {
                return this.tile.name;
            }

            public int func_70297_j_() {
                return 64;
            }

            public void func_70296_d() {
            }

            public boolean func_70300_a(EntityPlayer player) {
                return this.tile.canPlayerUse(player);
            }

            public void func_174889_b(EntityPlayer player) {
            }

            public void func_174886_c(EntityPlayer player) {
            }

            public int func_174887_a_(int id) {
                return 0;
            }

            public void func_174885_b(int id, int value) {
            }

            public int func_174890_g() {
                return 0;
            }

            public void func_174888_l() {
                int length = this.tile.slots.length;
                TileEntityLaserRelayItemWhitelist.access$002(this.tile, new ItemStack[length]);
                Arrays.fill(this.tile.slots, StackUtil.getNull());
            }

            public void func_70299_a(int i, ItemStack stack) {
                ((TileEntityLaserRelayItemWhitelist)this.tile).slots[i] = stack;
                this.func_70296_d();
            }

            public int func_70302_i_() {
                return this.tile.slots.length;
            }

            public ItemStack func_70301_a(int i) {
                if (i < this.func_70302_i_()) {
                    return this.tile.slots[i];
                }
                return StackUtil.getNull();
            }

            public ItemStack func_70298_a(int i, int j) {
                if (StackUtil.isValid(this.tile.slots[i])) {
                    if (StackUtil.getStackSize(this.tile.slots[i]) <= j) {
                        ItemStack stackAt = this.tile.slots[i];
                        ((TileEntityLaserRelayItemWhitelist)this.tile).slots[i] = StackUtil.getNull();
                        this.func_70296_d();
                        return stackAt;
                    }
                    ItemStack stackAt = this.tile.slots[i].func_77979_a(j);
                    if (StackUtil.getStackSize(this.tile.slots[i]) <= 0) {
                        ((TileEntityLaserRelayItemWhitelist)this.tile).slots[i] = StackUtil.getNull();
                    }
                    this.func_70296_d();
                    return stackAt;
                }
                return StackUtil.getNull();
            }

            public ItemStack func_70304_b(int index) {
                ItemStack stack = this.tile.slots[index];
                ((TileEntityLaserRelayItemWhitelist)this.tile).slots[index] = StackUtil.getNull();
                return stack;
            }

            public boolean func_145818_k_() {
                return false;
            }

            public ITextComponent func_145748_c_() {
                return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return false;
            }
        }).setTile(this);
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 10;
    }

    @Override
    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return output ? this.rightFilter.check(stack, this.slots) : this.leftFilter.check(stack, this.slots);
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            TileEntityInventoryBase.saveSlots(this.slots, compound);
        }
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.leftFilter.writeToNBT(compound, "LeftFilter");
            this.rightFilter.writeToNBT(compound, "RightFilter");
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            TileEntityInventoryBase.loadSlots(this.slots, compound);
        }
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.leftFilter.readFromNBT(compound, "LeftFilter");
            this.rightFilter.readFromNBT(compound, "RightFilter");
        }
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.leftFilter.onButtonPressed(buttonID);
        this.rightFilter.onButtonPressed(buttonID);
        if (buttonID == 2) {
            this.addWhitelistSmart(false);
        } else if (buttonID == 3) {
            this.addWhitelistSmart(true);
        }
    }

    private void addWhitelistSmart(boolean output) {
        FilterSettings usedSettings = output ? this.rightFilter : this.leftFilter;
        for (IItemHandler handler : this.handlersAround.values()) {
            block1: for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!StackUtil.isValid(stack)) continue;
                ItemStack copy = stack.func_77946_l();
                if (FilterSettings.check(copy = StackUtil.setStackSize(copy, 1), this.slots, usedSettings.startSlot, usedSettings.endSlot, true, usedSettings.respectMeta, usedSettings.respectNBT, usedSettings.respectMod, usedSettings.respectOredict)) continue;
                for (int k = usedSettings.startSlot; k < usedSettings.endSlot; ++k) {
                    if (StackUtil.isValid(this.slots[k])) {
                        if (!(this.slots[k].func_77973_b() instanceof ItemFilter)) continue;
                        ItemStack[] filterSlots = new ItemStack[24];
                        ItemDrill.loadSlotsFromNBT(filterSlots, this.slots[k]);
                        boolean did = false;
                        if (filterSlots != null && filterSlots.length > 0) {
                            for (int j = 0; j < filterSlots.length; ++j) {
                                if (StackUtil.isValid(filterSlots[j])) continue;
                                filterSlots[j] = copy;
                                did = true;
                                break;
                            }
                        }
                        if (!did) continue;
                        ItemDrill.writeSlotsToNBT(filterSlots, this.slots[k]);
                        continue block1;
                    }
                    this.slots[k] = copy;
                    continue block1;
                }
            }
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && (this.leftFilter.needsUpdateSend() || this.rightFilter.needsUpdateSend()) && this.sendUpdateWithInterval()) {
            this.leftFilter.updateLasts();
            this.rightFilter.updateLasts();
        }
    }

    static /* synthetic */ ItemStack[] access$002(TileEntityLaserRelayItemWhitelist x0, ItemStack[] x1) {
        x0.slots = x1;
        return x1;
    }
}

