/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerBag;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemBag
extends ItemBase {
    private final boolean isVoid;

    public ItemBag(String name, boolean isVoid) {
        super(name);
        this.isVoid = isVoid;
        this.func_77625_d(1);
        if (!this.isVoid) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemStack[] slots = new ItemStack[ContainerBag.getSlotAmount(this.isVoid)];
        ItemDrill.loadSlotsFromNBT(slots, stack);
        int slotsTotal = slots.length;
        int slotsFilled = 0;
        for (ItemStack slotStack : slots) {
            if (!StackUtil.isValid(slotStack)) continue;
            ++slotsFilled;
        }
        tooltip.add(TextFormatting.ITALIC.toString() + slotsFilled + "/" + (slotsTotal -= 4) + " filled slots");
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack;
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        EntityItem item = event.getItem();
        if (item != null && !item.field_70128_L && StackUtil.isValid(stack = item.func_92059_d())) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invStack;
                if (i != player.field_71071_by.field_70461_c && StackUtil.isValid(invStack = player.field_71071_by.func_70301_a(i)) && invStack.func_77973_b() instanceof ItemBag && invStack.func_77942_o() && invStack.func_77978_p().func_74767_n("AutoInsert")) {
                    boolean changed = false;
                    boolean isVoid = ((ItemBag)invStack.func_77973_b()).isVoid;
                    ItemStack[] inventory = new ItemStack[ContainerBag.getSlotAmount(isVoid)];
                    ItemDrill.loadSlotsFromNBT(inventory, invStack);
                    FilterSettings filter = new FilterSettings(0, 4, false, false, false, false, 0, 0);
                    filter.readFromNBT(invStack.func_77978_p(), "Filter");
                    if (filter.check(stack, inventory)) {
                        if (isVoid) {
                            stack.field_77994_a = 0;
                            changed = true;
                        } else {
                            for (int j = 4; j < inventory.length; ++j) {
                                ItemStack bagStack = inventory[j];
                                if (StackUtil.isValid(bagStack)) {
                                    int maxTransfer;
                                    if (ItemUtil.canBeStacked(bagStack, stack) && (maxTransfer = Math.min(StackUtil.getStackSize(stack), stack.func_77976_d() - StackUtil.getStackSize(bagStack))) > 0) {
                                        inventory[j] = StackUtil.addStackSize(bagStack, maxTransfer);
                                        stack.field_77994_a -= maxTransfer;
                                        changed = true;
                                    }
                                } else {
                                    inventory[j] = stack.func_77946_l();
                                    stack.field_77994_a = 0;
                                    changed = true;
                                }
                                if (!StackUtil.isValid(stack)) break;
                            }
                        }
                    }
                    if (changed) {
                        if (!isVoid) {
                            ItemDrill.writeSlotsToNBT(inventory, invStack);
                        }
                        event.setResult(Event.Result.ALLOW);
                    }
                }
                if (!StackUtil.isValid(stack)) break;
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!this.isVoid && (tile = worldIn.func_175625_s(pos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            IItemHandler handler;
            if (!worldIn.field_72995_K && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) != null) {
                boolean changed = false;
                ItemStack[] inventory = new ItemStack[ContainerBag.getSlotAmount(this.isVoid)];
                ItemDrill.loadSlotsFromNBT(inventory, stack);
                block0: for (int j = 4; j < inventory.length; ++j) {
                    ItemStack invStack = inventory[j];
                    if (!StackUtil.isValid(invStack)) continue;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack remain = handler.insertItem(i, invStack, false);
                        if (ItemStack.func_77989_b((ItemStack)remain, (ItemStack)invStack)) continue;
                        inventory[j] = StackUtil.validateCopy(remain);
                        changed = true;
                        if (!StackUtil.isValid(remain)) continue block0;
                    }
                }
                if (changed) {
                    ItemDrill.writeSlotsToNBT(inventory, stack);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            player.openGui((Object)ActuallyAdditions.instance, (this.isVoid ? GuiHandler.GuiTypes.VOID_BAG : GuiHandler.GuiTypes.BAG).ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isVoid ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }
}

