/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IFocus;
import net.blay09.mods.excompressum.compat.jei.WoodenCrucibleRecipe;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistryEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WoodenCrucibleRecipeCategory
extends BlankRecipeCategory<WoodenCrucibleRecipe> {
    public static final String UID = "excompressum:woodenCrucible";
    private static final ResourceLocation texture = new ResourceLocation("excompressum", "textures/gui/jei_wooden_crucible.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public WoodenCrucibleRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 130);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.excompressum:woodenCrucible", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, final WoodenCrucibleRecipe recipeWrapper, final IIngredients ingredients) {
        ItemStack fluidItem;
        if (FluidRegistry.isUniversalBucketEnabled()) {
            fluidItem = new ItemStack(Items.field_151133_ar);
            IFluidHandler fluidHandler = (IFluidHandler)fluidItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            fluidHandler.fill((FluidStack)ingredients.getOutputs(FluidStack.class).get(0), true);
        } else {
            fluidItem = FluidContainerRegistry.fillFluidContainer((FluidStack)((FluidStack)ingredients.getOutputs(FluidStack.class).get(0)), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        }
        recipeLayout.getItemStacks().init(0, false, 74, 9);
        recipeLayout.getItemStacks().set(0, fluidItem);
        IFocus focus = recipeLayout.getFocus();
        boolean hasFocus = focus.getMode() == IFocus.Mode.INPUT;
        this.hasHighlight = false;
        List inputs = ingredients.getInputs(ItemStack.class);
        boolean INPUT_SLOTS = true;
        int slotNumber = 0;
        for (List input : inputs) {
            int slotX = 2 + slotNumber % 9 * 18;
            int slotY = 36 + slotNumber / 9 * 18;
            recipeLayout.getItemStacks().init(1 + slotNumber, true, slotX, slotY);
            recipeLayout.getItemStacks().set(1 + slotNumber, input);
            Object focusValue = focus.getValue();
            if (hasFocus && focusValue instanceof ItemStack) {
                ItemStack focusStack = (ItemStack)focus.getValue();
                for (ItemStack inputVariant : input) {
                    if (focusStack.func_77973_b() != inputVariant.func_77973_b() || focusStack.func_77952_i() != inputVariant.func_77952_i()) continue;
                    this.hasHighlight = true;
                    this.highlightX = slotX;
                    this.highlightY = slotY;
                    break;
                }
            }
            ++slotNumber;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
                if (input) {
                    WoodenCrucibleRegistryEntry entry = recipeWrapper.getEntryAt(slotIndex - 1);
                    tooltip.add(recipeWrapper.getFluid().getLocalizedName((FluidStack)ingredients.getOutputs(FluidStack.class).get(0)));
                    tooltip.add(" * " + entry.getAmount() + " mB");
                }
            }
        });
    }
}

