/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistryEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class WoodenCrucibleRecipe
extends BlankRecipeWrapper {
    private final Fluid fluid;
    private final List<WoodenCrucibleRegistryEntry> entries;
    private final List<ItemStack> inputs;
    private final List<FluidStack> fluidOutputs;

    public WoodenCrucibleRecipe(Fluid fluid, List<WoodenCrucibleRegistryEntry> entries) {
        this.fluid = fluid;
        this.entries = entries;
        this.inputs = Lists.newArrayList();
        for (WoodenCrucibleRegistryEntry entry : entries) {
            this.inputs.add(entry.getItemStack());
        }
        this.fluidOutputs = Collections.singletonList(new FluidStack(fluid, 1000));
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public WoodenCrucibleRegistryEntry getEntryAt(int index) {
        return this.entries.get(index);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(FluidStack.class, this.fluidOutputs);
    }
}

