/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.exnihiloadscensio;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihiloadscensio.registries.CompostRegistry;
import exnihiloadscensio.registries.CrookRegistry;
import exnihiloadscensio.registries.HammerRegistry;
import exnihiloadscensio.registries.RegistryReloadedEvent;
import exnihiloadscensio.registries.SieveRegistry;
import exnihiloadscensio.registries.types.CrookReward;
import exnihiloadscensio.registries.types.Siftable;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.util.BlockInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.compat.SieveModelBounds;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ExNihiloAdscensioAddon
implements ExNihiloProvider,
IAddon {
    private final EnumMap<ExNihiloProvider.NihiloItems, ItemStack> itemMap = Maps.newEnumMap(ExNihiloProvider.NihiloItems.class);
    private final SieveModelBounds bounds;
    private Enchantment sieveEfficiency;
    private Enchantment sieveFortune;

    public ExNihiloAdscensioAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.bounds = new SieveModelBounds(0.8125f, 0.0625f, 0.88f, 0.15625f);
        ExRegistro.instance = this;
    }

    @Override
    public void init() {
        ItemStack diamondMeshItem;
        ItemStack ironMeshItem;
        ItemStack flintMeshItem;
        this.sieveEfficiency = Enchantment.func_180305_b((String)"exnihiloadscensio:sieveEfficiency");
        this.sieveFortune = Enchantment.func_180305_b((String)"exnihiloadscensio:sieveFortune");
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_WOODEN, this.findItem("hammerWood", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_STONE, this.findItem("hammerStone", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_IRON, this.findItem("hammerIron", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_GOLD, this.findItem("hammerGold", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_DIAMOND, this.findItem("hammerDiamond", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.CROOK_WOODEN, this.findItem("crookWood", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SILK_MESH, this.findItem("itemMesh", 1));
        this.itemMap.put(ExNihiloProvider.NihiloItems.IRON_MESH, this.findItem("itemMesh", 3));
        this.itemMap.put(ExNihiloProvider.NihiloItems.DUST, this.findBlock("blockDust", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SIEVE, this.findBlock("blockSieve", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.INFESTED_LEAVES, this.findBlock("blockInfestedLeaves", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.NETHER_GRAVEL, this.findBlock("blockNetherrackCrushed", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.ENDER_GRAVEL, this.findBlock("blockEndstoneCrushed", 0));
        ItemStack stringMeshItem = this.getNihiloItem(ExNihiloProvider.NihiloItems.SILK_MESH);
        if (stringMeshItem != null) {
            SieveMeshRegistryEntry stringMesh = new SieveMeshRegistryEntry(stringMeshItem);
            stringMesh.setMeshLevel(1);
            stringMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/string_mesh"));
            SieveMeshRegistry.add(stringMesh);
        }
        if ((flintMeshItem = this.findItem("itemMesh", 2)) != null) {
            SieveMeshRegistryEntry flintMesh = new SieveMeshRegistryEntry(flintMeshItem);
            flintMesh.setMeshLevel(2);
            flintMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/flint_mesh"));
            SieveMeshRegistry.add(flintMesh);
        }
        if ((ironMeshItem = this.getNihiloItem(ExNihiloProvider.NihiloItems.IRON_MESH)) != null) {
            SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(ironMeshItem);
            ironMesh.setMeshLevel(3);
            ironMesh.setHeavy(true);
            ironMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/iron_mesh"));
            SieveMeshRegistry.add(ironMesh);
        }
        if ((diamondMeshItem = this.findItem("itemMesh", 4)) != null) {
            SieveMeshRegistryEntry diamondMesh = new SieveMeshRegistryEntry(diamondMeshItem);
            diamondMesh.setMeshLevel(4);
            diamondMesh.setHeavy(true);
            diamondMesh.setSpriteLocation(new ResourceLocation("excompressum", "blocks/diamond_mesh"));
            SieveMeshRegistry.add(diamondMesh);
        }
    }

    @SubscribeEvent
    public void onRegistryReload(RegistryReloadedEvent event) {
        if (ExCompressumConfig.enableWoodChippings) {
            HammerRegistry.register((IBlockState)Blocks.field_150364_r.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)1.0f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150364_r.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.75f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150364_r.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.5f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150364_r.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.25f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150363_s.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)1.0f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150363_s.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.75f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150363_s.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.5f, (float)0.0f, (boolean)true);
            HammerRegistry.register((IBlockState)Blocks.field_150363_s.func_176223_P(), (ItemStack)new ItemStack((Item)ModItems.woodChipping), (int)0, (float)0.25f, (float)0.0f, (boolean)true);
            List oreDictStacks = OreDictionary.getOres((String)"dustWood", (boolean)false);
            for (ItemStack itemStack : oreDictStacks) {
                CompostRegistry.register((Item)itemStack.func_77973_b(), (int)itemStack.func_77952_i(), (float)0.125f, (IBlockState)Blocks.field_150346_d.func_176223_P(), (Color)new Color(-3704794));
            }
        }
    }

    @Override
    public SieveModelBounds getSieveBounds() {
        return this.bounds;
    }

    @Override
    public Collection<HeavySieveReward> generateHeavyRewards(ItemStack sourceStack, int count) {
        ArrayList siftables = SieveRegistry.getDrops((ItemStack)sourceStack);
        if (siftables != null) {
            ArrayList rewards = Lists.newArrayList();
            for (Siftable siftable : siftables) {
                if (siftable.getDrop().getItem() == null) {
                    ExCompressum.logger.error("Tried to generate Heavy Sieve rewards from a null reward entry: {}", new Object[]{sourceStack.func_77973_b().getRegistryName()});
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    rewards.add(new HeavySieveReward(siftable.getDrop().getItemStack(), siftable.getChance(), siftable.getMeshLevel()));
                }
            }
            return rewards;
        }
        return Collections.emptyList();
    }

    @Nullable
    private ItemStack findItem(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihiloadscensio", name);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (item != null) {
            return new ItemStack(item, 1, withMetadata);
        }
        return null;
    }

    @Nullable
    private ItemStack findBlock(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihiloadscensio", name);
        if (Block.field_149771_c.func_148741_d((Object)location)) {
            return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)location), 1, withMetadata);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getNihiloItem(ExNihiloProvider.NihiloItems type) {
        return this.itemMap.get((Object)type);
    }

    @Override
    public boolean isHammerable(IBlockState state) {
        return HammerRegistry.registered((Block)state.func_177230_c());
    }

    @Override
    public Collection<ItemStack> rollHammerRewards(IBlockState state, int miningLevel, float luck, Random rand) {
        return HammerRegistry.getRewardDrops((Random)rand, (IBlockState)state, (int)miningLevel, (int)((int)luck));
    }

    @Override
    public boolean isSiftable(IBlockState state) {
        ArrayList siftables = SieveRegistry.getDrops((BlockInfo)new BlockInfo(state));
        return siftables != null && !siftables.isEmpty();
    }

    @Override
    public boolean isSiftableWithMesh(IBlockState state, SieveMeshRegistryEntry sieveMesh) {
        ArrayList siftables = SieveRegistry.getDrops((BlockInfo)new BlockInfo(state));
        if (siftables != null) {
            for (Siftable siftable : siftables) {
                if (siftable.getMeshLevel() != sieveMesh.getMeshLevel()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ItemStack> rollSieveRewards(IBlockState state, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        ArrayList rewards = SieveRegistry.getDrops((BlockInfo)new BlockInfo(state));
        if (rewards != null) {
            ArrayList list = Lists.newArrayList();
            for (Siftable reward : rewards) {
                if (reward.getDrop().getItem() == null) {
                    ExCompressum.logger.error("Tried to roll sieve rewards from a null reward entry: {} (base chance: {}, mesh level: {})", new Object[]{state.func_177230_c().getRegistryName(), Float.valueOf(reward.getChance()), reward.getMeshLevel()});
                    continue;
                }
                int tries = rand.nextInt((int)luck + 1) + 1;
                for (int i = 0; i < tries; ++i) {
                    if (sieveMesh.getMeshLevel() != reward.getMeshLevel() || !(rand.nextDouble() < (double)reward.getChance())) continue;
                    list.add(reward.getDrop().getItemStack());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ItemStack> rollCrookRewards(EntityLivingBase player, IBlockState state, float luck, Random rand) {
        ArrayList rewards = CrookRegistry.getRewards((IBlockState)state);
        if (rewards != null) {
            ArrayList list = Lists.newArrayList();
            for (CrookReward reward : rewards) {
                if (reward.getStack().func_77973_b() == null) {
                    ExCompressum.logger.error("Tried to roll crook rewards from a null reward entry: {} (base chance: {}, luck: {})", new Object[]{state.func_177230_c().getRegistryName(), Float.valueOf(reward.getChance()), Float.valueOf(reward.getFortuneChance())});
                    continue;
                }
                if (!(rand.nextFloat() <= reward.getChance() + reward.getFortuneChance() * luck)) continue;
                list.add(reward.getStack().func_77946_l());
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void loadConfig(Configuration config) {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @Override
    public boolean doMeshesHaveDurability() {
        return false;
    }

    @Override
    public boolean doMeshesSplitLootTables() {
        return true;
    }

    @Override
    public ExNihiloProvider.NihiloMod getNihiloMod() {
        return ExNihiloProvider.NihiloMod.ADSCENSIO;
    }

    @Override
    public int getMeshFortune(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)meshStack) + EnchantmentHelper.func_77506_a((Enchantment)this.sieveFortune, (ItemStack)meshStack);
    }

    @Override
    public int getMeshEfficiency(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)meshStack) + EnchantmentHelper.func_77506_a((Enchantment)this.sieveEfficiency, (ItemStack)meshStack);
    }
}

