/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockAutoSieveBase
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private ItemStack lastHoverStack;
    private String currentRandomName;

    protected BlockAutoSieveBase(Material material) {
        super(material);
        this.func_149647_a(ExCompressum.creativeTab);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nullable
    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileAutoSieveBase tileEntity;
            if (heldItem != null && (tileEntity = (TileAutoSieveBase)world.func_175625_s(pos)) != null) {
                if (heldItem.func_77973_b() instanceof ItemFood) {
                    ItemFood itemFood = (ItemFood)heldItem.func_77973_b();
                    if (tileEntity.getFoodBoost() <= 1.0f) {
                        ItemStack returnStack;
                        tileEntity.setFoodBoost((int)(itemFood.func_150906_h(heldItem) * 640.0f), Math.max(1.0f, (float)itemFood.func_150905_g(heldItem) * 0.75f));
                        if (!player.field_71075_bZ.field_75098_d && (returnStack = itemFood.func_77654_b(heldItem, world, null)) != heldItem) {
                            player.func_184611_a(hand, returnStack);
                        }
                        world.func_175718_b(2005, pos, 0);
                    }
                    return true;
                }
                if (heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s()) {
                    tileEntity.setCustomSkin(new GameProfile(null, heldItem.func_82833_r()));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldItem.field_77994_a;
                    }
                    return true;
                }
            }
            if (!player.func_70093_af()) {
                player.openGui((Object)ExCompressum.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            double motion;
            EntityItem entityItem;
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.getStackInSlot(i) == null) continue;
                entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemHandler.getStackInSlot(i));
                motion = 0.05;
                entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
                entityItem.field_70181_x = 0.2;
                entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
                world.func_72838_d((Entity)entityItem);
            }
            ItemStack currentStack = ((TileAutoSieveBase)tileEntity).getCurrentStack();
            if (currentStack != null) {
                entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), currentStack);
                motion = 0.05;
                entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
                entityItem.field_70181_x = 0.2;
                entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
                world.func_72838_d((Entity)entityItem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing facing = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileAutoSieveBase tileEntity = (TileAutoSieveBase)world.func_175625_s(pos);
        if (tileEntity != null) {
            GameProfile customSkin;
            boolean useRandomSkin = true;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b("CustomSkin") && (customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"))) != null) {
                tileEntity.setCustomSkin(customSkin);
                useRandomSkin = false;
            }
            if (!world.field_72995_K && useRandomSkin) {
                tileEntity.setCustomSkin(new GameProfile(null, AutoSieveSkinRegistry.getRandomSkin()));
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return StupidUtils.getComparatorOutput64(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean flag) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("CustomSkin")) {
            GameProfile customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"));
            if (customSkin != null) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip." + this.getRegistryName()), (Object[])new Object[]{customSkin.getName()}));
            }
        } else {
            if (this.currentRandomName == null) {
                this.currentRandomName = AutoSieveSkinRegistry.getRandomSkin();
            }
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip." + this.getRegistryName()), (Object[])new Object[]{this.currentRandomName}));
        }
        if (this.lastHoverStack != itemStack) {
            this.currentRandomName = AutoSieveSkinRegistry.getRandomSkin();
            this.lastHoverStack = itemStack;
        }
    }
}

