/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.blay09.mods.excompressum.CommandExCompressum;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressumCreativeTab;
import net.blay09.mods.excompressum.InternalMethods;
import net.blay09.mods.excompressum.ModRecipes;
import net.blay09.mods.excompressum.api.ExCompressumAPI;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.entity.EntityAngryChicken;
import net.blay09.mods.excompressum.handler.ChickenStickHandler;
import net.blay09.mods.excompressum.handler.CompressedCrookHandler;
import net.blay09.mods.excompressum.handler.CompressedEnemyHandler;
import net.blay09.mods.excompressum.handler.CompressedHammerHandler;
import net.blay09.mods.excompressum.handler.GuiHandler;
import net.blay09.mods.excompressum.handler.HammerHandler;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.NihilisticNihiloProvider;
import net.blay09.mods.excompressum.registry.chickenstick.ChickenStickRegistry;
import net.blay09.mods.excompressum.registry.compressedhammer.CompressedHammerRegistry;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistry;
import net.minecraft.command.ICommand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="excompressum", name="Ex Compressum", dependencies="after:exnihiloomnia;after:exnihiloadscensio;required-after:Forge@[12.18.1.2080,)", acceptedMinecraftVersions="[1.10.2]")
public class ExCompressum {
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "excompressum";
    @Mod.Instance
    public static ExCompressum instance;
    @SidedProxy(serverSide="net.blay09.mods.excompressum.CommonProxy", clientSide="net.blay09.mods.excompressum.client.ClientProxy")
    public static CommonProxy proxy;
    public static File configDir;
    private Configuration config;
    public static final ExCompressumCreativeTab creativeTab;
    public final List<IAddon> addons = Lists.newArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ExCompressumAPI.__setupAPI(new InternalMethods());
        configDir = new File(event.getModConfigurationDirectory(), "ExCompressum");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Couldn't create Ex Compressum configuration directory");
        }
        this.config = new Configuration(new File(configDir, "ExCompressum.cfg"));
        this.config.load();
        ExCompressumConfig.preInit(this.config);
        ModItems.init();
        ModBlocks.init();
        EntityRegistry.registerModEntity(EntityAngryChicken.class, (String)"AngryChicken", (int)0, (Object)this, (int)64, (int)3, (boolean)true);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new HammerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedHammerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedCrookHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedEnemyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenStickHandler());
        this.registerAddon("Botania", "net.blay09.mods.excompressum.compat.botania.BotaniaAddon");
        this.registerAddon("exnihiloomnia", "net.blay09.mods.excompressum.compat.exnihiloomnia.ExNihiloOmniaAddon");
        this.registerAddon("exnihiloadscensio", "net.blay09.mods.excompressum.compat.exnihiloadscensio.ExNihiloAdscensioAddon");
        proxy.preInit(event);
        for (IAddon addon : this.addons) {
            proxy.preInitAddon(addon);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ExCompressumConfig.init(this.config);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.blay09.mods.excompressum.compat.top.TheOneProbeAddon");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.blay09.mods.excompressum.compat.waila.WailaProvider.register");
        proxy.init(event);
        for (IAddon addon : this.addons) {
            addon.init();
        }
        ModRecipes.init();
        ChickenStickRegistry.INSTANCE.load(configDir);
        WoodenCrucibleRegistry.INSTANCE.load(configDir);
        CompressedHammerRegistry.INSTANCE.load(configDir);
        HeavySieveRegistry.INSTANCE.load(configDir);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ExRegistro.instance == null) {
            logger.warn("No Ex Nihilo mod installed - many things will be disabled. Why would you run Ex Compressum without Ex Nihilo? Pfft.");
            ExRegistro.instance = new NihilisticNihiloProvider();
        }
        CompressedRecipeRegistry.reload();
        SieveMeshRegistry.registerDefaults();
        AutoSieveSkinRegistry.load();
        this.registerAddon("MineTweaker3", "net.blay09.mods.excompressum.compat.minetweaker.MineTweakerAddon");
        this.registerAddon("tconstruct", "net.blay09.mods.excompressum.compat.tconstruct.TConstructAddon");
        for (IAddon addon : this.addons) {
            addon.loadConfig(this.config);
            addon.postInit();
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
        proxy.postInit(event);
    }

    private Optional<?> buildSoftDependProxy(String modId, String className, Object ... arguments) {
        if (Loader.isModLoaded((String)modId)) {
            try {
                Class<?> clz = Class.forName(className, true, (ClassLoader)Loader.instance().getModClassLoader());
                return Optional.fromNullable(clz.newInstance());
            }
            catch (Exception e) {
                return Optional.absent();
            }
        }
        return Optional.absent();
    }

    private void registerAddon(String modid, String className) {
        Optional<?> optional = this.buildSoftDependProxy(modid, className, new Object[0]);
        if (optional.isPresent()) {
            this.addons.add((IAddon)optional.get());
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandExCompressum());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        for (IAddon addon : this.addons) {
            addon.serverStarted(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (AbstractRegistry.registryErrors.size() > 0) {
            event.player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "There were errors loading the Ex Compressum registries:"));
            TextFormatting lastFormatting = TextFormatting.WHITE;
            for (String error : AbstractRegistry.registryErrors) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(lastFormatting + "* " + error));
                lastFormatting = lastFormatting == TextFormatting.GRAY ? TextFormatting.WHITE : TextFormatting.GRAY;
            }
        }
    }

    static {
        creativeTab = new ExCompressumCreativeTab();
    }
}

