/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.recipe.AdvRecipe;
import ic2.core.recipe.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.common.MetaItem;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.recipe.AbstractRecipeResearcher;

public class IC2RecipeResearcher
extends AbstractRecipeResearcher<AdvRecipe, AdvShapelessRecipe> {
    public int getShapedRecipeKey(@Nonnull AdvRecipe recipe) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (IRecipeInput input : recipe.input) {
            List bufferInput = input.getInputs();
            if (bufferInput.isEmpty()) continue;
            recipeKeys.add(MetaItem.get((ItemStack)this.resourceHandler.getMainItemStack((ItemStack)bufferInput.get(0))));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull AdvShapelessRecipe recipe) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (IRecipeInput input : recipe.input) {
            List bufferInput = input.getInputs();
            if (bufferInput.isEmpty()) continue;
            recipeKeys.add(MetaItem.get((ItemStack)this.resourceHandler.getMainItemStack((ItemStack)bufferInput.get(0))));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends AdvRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(AdvRecipe.class);
    }

    @Nonnull
    public List<Class<? extends AdvShapelessRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(AdvShapelessRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull AdvRecipe recipe) {
        Object[] newRecipeInputs = new Object[9];
        IRecipeInput[] recipeInputs = recipe.input;
        if (itemStacksOnly) {
            for (int i = 0; i < recipeInputs.length; ++i) {
                List inputs = recipeInputs[i].getInputs();
                if (inputs.isEmpty()) continue;
                newRecipeInputs[i] = this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0));
            }
        } else {
            for (int i = 0; i < recipeInputs.length; ++i) {
                String oreName;
                IRecipeInput input = recipeInputs[i];
                String string = oreName = input instanceof RecipeInputOreDict ? ((RecipeInputOreDict)input).input : null;
                if (oreName == null) {
                    boolean notEmpty = !input.getInputs().isEmpty();
                    String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(input.getInputs().get(0)) : null;
                    if (oreName != null) {
                        newRecipeInputs[i] = oreName;
                        continue;
                    }
                    if (!notEmpty) continue;
                    newRecipeInputs[i] = input.getInputs().get(0);
                    continue;
                }
                newRecipeInputs[i] = oreName;
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull AdvShapelessRecipe recipe) {
        Object[] newRecipeInputs = new Object[9];
        IRecipeInput[] recipeInputs = recipe.input;
        if (itemStacksOnly) {
            for (int i = 0; i < recipeInputs.length; ++i) {
                List inputs = recipeInputs[i].getInputs();
                if (inputs.isEmpty()) continue;
                newRecipeInputs[i] = this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0));
            }
        } else {
            for (int i = 0; i < recipeInputs.length; ++i) {
                String oreName;
                IRecipeInput input = recipeInputs[i];
                String string = oreName = input instanceof RecipeInputOreDict ? ((RecipeInputOreDict)input).input : null;
                if (oreName == null) {
                    boolean notEmpty = !input.getInputs().isEmpty();
                    String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(input.getInputs().get(0)) : null;
                    if (oreName != null) {
                        newRecipeInputs[i] = oreName;
                        continue;
                    }
                    if (!notEmpty) continue;
                    newRecipeInputs[i] = input.getInputs().get(0);
                    continue;
                }
                newRecipeInputs[i] = oreName;
            }
        }
        return new ShapedOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape((Object[])newRecipeInputs));
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull AdvShapelessRecipe recipe) {
        ArrayList<String> newInputs = new ArrayList<String>();
        if (itemStacksOnly) {
            for (IRecipeInput recipeInput : recipe.input) {
                List inputs = recipeInput.getInputs();
                if (inputs.isEmpty()) continue;
                inputs.add(this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0)));
            }
        } else {
            for (IRecipeInput recipeInput : recipe.input) {
                String oreName;
                String string = oreName = recipeInput instanceof RecipeInputOreDict ? ((RecipeInputOreDict)recipeInput).input : null;
                if (oreName == null) {
                    boolean notEmpty = !recipeInput.getInputs().isEmpty();
                    String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(recipeInput.getInputs().get(0)) : null;
                    if (oreName != null) {
                        newInputs.add(oreName);
                        continue;
                    }
                    if (!notEmpty) continue;
                    newInputs.add((String)recipeInput.getInputs().get(0));
                    continue;
                }
                newInputs.add(oreName);
            }
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), newInputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull AdvRecipe recipe) {
        ArrayList<String> newInputs = new ArrayList<String>();
        if (itemStacksOnly) {
            for (IRecipeInput recipeInput : recipe.input) {
                List inputs = recipeInput.getInputs();
                if (inputs.isEmpty()) continue;
                inputs.add(this.resourceHandler.getMainItemStack((ItemStack)inputs.get(0)));
            }
        } else {
            for (IRecipeInput recipeInput : recipe.input) {
                String oreName;
                String string = oreName = recipeInput instanceof RecipeInputOreDict ? ((RecipeInputOreDict)recipeInput).input : null;
                if (oreName == null) {
                    boolean notEmpty = !recipeInput.getInputs().isEmpty();
                    String string2 = oreName = notEmpty ? this.uniOreDictionary.getName(recipeInput.getInputs().get(0)) : null;
                    if (oreName != null) {
                        newInputs.add(oreName);
                        continue;
                    }
                    if (!notEmpty) continue;
                    newInputs.add((String)recipeInput.getInputs().get(0));
                    continue;
                }
                newInputs.add(oreName);
            }
        }
        return new ShapelessOreRecipe(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), newInputs.toArray());
    }
}

