/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import waterpower.common.recipe.HashMapRecipeManager;
import waterpower.common.recipe.IRecipeManager;
import waterpower.common.recipe.MultiRecipeManager;
import waterpower.common.recipe.MyRecipeManager;
import waterpower.common.recipe.MyRecipeOutput;
import waterpower.common.recipe.MyRecipes;

final class WaterPowerIntegration
extends AbstractIntegrationThread {
    private final Field hashMapRecipeField;
    private final Field multiRecipeField;
    private final Field myRecipeField;

    WaterPowerIntegration() {
        super("Water Power");
        try {
            this.hashMapRecipeField = HashMapRecipeManager.class.getDeclaredField("recipes");
            this.hashMapRecipeField.setAccessible(true);
            this.multiRecipeField = MultiRecipeManager.class.getDeclaredField("container");
            this.multiRecipeField.setAccessible(true);
            this.myRecipeField = MyRecipeManager.class.getDeclaredField("recipes");
            this.myRecipeField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Couldn't find container field");
        }
    }

    public String call() {
        try {
            this.fixRecipes(MyRecipes.centrifuge);
            this.fixRecipes(MyRecipes.compressor);
            this.fixRecipes(MyRecipes.cutter);
            this.fixRecipes(MyRecipes.implosion);
            this.fixRecipes(MyRecipes.lathe);
            this.fixRecipes(MyRecipes.macerator);
            this.fixRecipes(MyRecipes.sawmill);
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Correct Output for machines =p";
    }

    private void fixRecipes(@Nonnull IRecipeManager iRecipeManager) {
        if (iRecipeManager instanceof HashMapRecipeManager) {
            try {
                HashMap recipes = (HashMap)this.hashMapRecipeField.get(iRecipeManager);
                if (recipes != null) {
                    recipes.entrySet().forEach(entry -> entry.setValue(this.resourceHandler.getMainItemStack((ItemStack)entry.getValue())));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (iRecipeManager instanceof MultiRecipeManager) {
            try {
                List container = (List)this.multiRecipeField.get(iRecipeManager);
                if (container != null) {
                    container.forEach(this::fixRecipes);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (iRecipeManager instanceof MyRecipeManager) {
            try {
                Map recipes = (Map)this.myRecipeField.get(iRecipeManager);
                if (recipes != null) {
                    recipes.entrySet().forEach(entry -> entry.setValue(new MyRecipeOutput(((MyRecipeOutput)entry.getValue()).power, this.resourceHandler.getMainItemStacks(((MyRecipeOutput)entry.getValue()).items))));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

