/*
 * Decompiled with CFR 0.152.
 */
package RebornStorage.tiles;

import RebornStorage.blocks.BlockMultiCrafter;
import RebornStorage.multiblocks.MultiBlockCrafter;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.INetworkNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import reborncore.common.util.Inventory;

public class TileMultiCrafter
extends RectangularMultiblockTileEntityBase
implements ICraftingPatternContainer,
INetworkNode {
    INetworkMaster master;
    public Inventory inv;
    public Optional<Integer> page = Optional.empty();

    public void isGoodForFrame() throws MultiblockValidationException {
        if (!this.getVarient().equals("frame")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the frame of the block");
        }
    }

    public void isGoodForSides() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForTop() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForBottom() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForInterior() throws MultiblockValidationException {
        if (!this.getVarient().equals("cpu") && !this.getVarient().equals("storage")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the inside of the block");
        }
    }

    public void onMachineActivated() {
        if (this.getMultiBlock() != null) {
            MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
            if (multiBlockCrafter.network == null) {
                multiBlockCrafter.network = this.master;
            }
            multiBlockCrafter.rebuildPatterns();
        }
    }

    public void onMachineDeactivated() {
        if (this.getMultiBlock() != null) {
            MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
            if (multiBlockCrafter.network == null) {
                multiBlockCrafter.network = this.master;
            }
            multiBlockCrafter.rebuildPatterns();
        }
    }

    String getVarient() {
        return (String)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMultiCrafter.VARIANTS));
    }

    public MultiblockControllerBase createNewMultiblock() {
        return new MultiBlockCrafter(this.func_145831_w());
    }

    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiBlockCrafter.class;
    }

    public MultiBlockCrafter getMultiBlock() {
        return (MultiBlockCrafter)this.getMultiblockController();
    }

    public int getEnergyUsage() {
        if (this.getMultiBlock() == null || !this.getMultiBlock().isConsumingPower()) {
            return 0;
        }
        switch ((String)((Object)this.getBlockState().func_177229_b((IProperty)BlockMultiCrafter.VARIANTS))) {
            case "cpu": {
                return 10;
            }
            case "storage": {
                return 5;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.inv != null && this.inv.hasChanged) {
            this.inv.hasChanged = false;
            MultiBlockCrafter multiBlockCrafter = this.getMultiBlock();
            if (multiBlockCrafter != null) {
                multiBlockCrafter.rebuildPatterns();
            }
        }
    }

    public int getSpeedUpdateCount() {
        if (this.getMultiBlock() == null) {
            return 0;
        }
        return this.getMultiBlock().speed;
    }

    public IItemHandler getFacingInventory() {
        return null;
    }

    public TileEntity getFacingTile() {
        return null;
    }

    public List<ICraftingPattern> getPatterns() {
        if (this.getMultiBlock() == null) {
            return new ArrayList<ICraftingPattern>();
        }
        return this.getMultiBlock().actualPatterns;
    }

    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void onConnected(INetworkMaster iNetworkMaster) {
        if (this.getMultiBlock() != null) {
            this.getMultiBlock().onConnectionChange(iNetworkMaster, true, this.field_174879_c);
        }
        this.master = iNetworkMaster;
    }

    public void onDisconnected(INetworkMaster iNetworkMaster) {
        if (this.getMultiBlock() != null) {
            this.getMultiBlock().onConnectionChange(iNetworkMaster, false, this.field_174879_c);
        }
        this.master = iNetworkMaster;
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean canConduct(EnumFacing enumFacing) {
        return true;
    }

    public INetworkMaster getNetwork() {
        if (this.getMultiBlock() != null) {
            return this.getMultiBlock().network;
        }
        return null;
    }

    public World getNodeWorld() {
        return this.field_145850_b;
    }

    public TileMultiCrafter(String varient) {
        if (varient.equals("storage")) {
            this.inv = new Inventory(78, "storageBlock", 1, (TileEntity)this);
        }
    }

    public void onLoad() {
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (this.inv == null && data.func_74764_b("hasInv")) {
            this.inv = new Inventory(78, "storageBlock", 1, (TileEntity)this);
        }
        if (this.inv != null) {
            this.inv.readFromNBT(data);
        }
        if (data.func_74764_b("page")) {
            this.page = Optional.of(data.func_74762_e("page"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.inv != null) {
            this.inv.writeToNBT(data);
            data.func_74757_a("hasInv", true);
        }
        if (this.page.isPresent()) {
            data.func_74768_a("page", this.page.get().intValue());
        }
        return super.func_189515_b(data);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public TileMultiCrafter() {
    }
}

