/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.literalascension.common.block;

import com.google.common.base.Predicate;
import com.jamieswhiteshirt.literalascension.api.ISpecialLadderBlock;
import com.jamieswhiteshirt.literalascension.common.block.BlockClimbingRope;
import com.jamieswhiteshirt.literalascension.features.ClimbingRope;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0001BB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0017J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020#H\u0017J<\u0010-\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010&H\u0016J\u001e\u00101\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u00102\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u00103\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u00104\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u00105\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J&\u00106\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u00020&2\u0006\u00107\u001a\u000208J&\u00109\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#J.\u0010:\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<2\u0006\u0010\"\u001a\u00020#J(\u0010=\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0001H\u0017J0\u0010?\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010@\u001a\u00020\tH\u0016J&\u0010A\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006C"}, d2={"Lcom/jamieswhiteshirt/literalascension/common/block/BlockClimbingRope;", "Lnet/minecraft/block/Block;", "Lcom/jamieswhiteshirt/literalascension/api/ISpecialLadderBlock;", "feature", "Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;", "(Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;)V", "getFeature", "()Lcom/jamieswhiteshirt/literalascension/features/ClimbingRope;", "canClimb", "", "state", "Lnet/minecraft/block/state/IBlockState;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "checkAndDropBlock", "", "Lnet/minecraft/world/World;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getBlockLayer", "Lnet/minecraft/util/BlockRenderLayer;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "getCollisionBoundingBox", "worldIn", "getItemDropped", "Lnet/minecraft/item/Item;", "rand", "Ljava/util/Random;", "fortune", "", "getMetaFromState", "getPickBlock", "Lnet/minecraft/item/ItemStack;", "target", "Lnet/minecraft/util/math/RayTraceResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getStateFromMeta", "meta", "harvestBlock", "te", "Lnet/minecraft/tileentity/TileEntity;", "stack", "isAttached", "isAttachedToBlock", "isAttachedToRope", "isFullCube", "isOpaqueCube", "launchDropAsEntity", "facing", "Lnet/minecraft/util/EnumFacing;", "launchDropBlockAsItem", "launchDropBlockAsItemWithChance", "chance", "", "neighborChanged", "block", "removedByPlayer", "willHarvest", "shouldLaunchDrop", "Companion", "literal-ascension_main"})
public final class BlockClimbingRope
extends Block
implements ISpecialLadderBlock {
    @NotNull
    private final ClimbingRope feature;
    @NotNull
    private static final PropertyDirection FACING;
    private static final AxisAlignedBB[] boundingBoxes;
    private static final AxisAlignedBB[] collisionBoxes;
    private static final AxisAlignedBB[] ladderCollisionBoxes;
    public static final Companion Companion;

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return BlockClimbingRope.Companion.getBoundingBoxes()[((EnumFacing)state.func_177229_b((IProperty)Companion.getFACING())).func_176745_a() - 1];
    }

    @NotNull
    public AxisAlignedBB func_180646_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return BlockClimbingRope.Companion.getCollisionBoxes()[((EnumFacing)state.func_177229_b((IProperty)Companion.getFACING())).func_176745_a() - 1];
    }

    public boolean func_149662_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return false;
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState state, @NotNull Random rand, int fortune) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        return this.feature.getItem();
    }

    public boolean func_149686_d(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return false;
    }

    @Override
    public boolean canClimb(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLivingBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return BlockClimbingRope.Companion.getLadderCollisionBoxes()[((EnumFacing)state.func_177229_b((IProperty)Companion.getFACING())).func_176745_a() - 1].func_186670_a(pos).func_72326_a(entity.func_174813_aQ());
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)Companion.getFACING(), (Comparable)EnumFacing.func_82600_a((int)(meta + 1)));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"defaultState.withPropert\u2026acing.getFront(meta + 1))");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return ((EnumFacing)state.func_177229_b((IProperty)Companion.getFACING())).func_176745_a() - 1;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{(IProperty)Companion.getFACING()});
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        super.func_189540_a(state, world, pos, block);
        this.checkAndDropBlock(world, pos, state);
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return new ItemStack((Item)this.feature.getItem());
    }

    public boolean removedByPlayer(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean willHarvest) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.func_176208_a(world, pos, state, player);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Companion.getFACING());
        BlockPos.MutableBlockPos breakPos = new BlockPos.MutableBlockPos(pos);
        while (true) {
            BlockPos blockPos = breakPos.func_177977_b();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"breakPos.down()");
            EnumFacing enumFacing = facing;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
            if (!this.feature.isMatchingBlock(world, blockPos, enumFacing)) break;
            BlockPos.MutableBlockPos mutableBlockPos = breakPos;
            int n = mutableBlockPos.func_177956_o();
            mutableBlockPos.func_185336_p(n + -1);
        }
        return world.func_180501_a((BlockPos)breakPos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public void func_180657_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        this.harvesters.set(player);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        if (this.shouldLaunchDrop(world, pos, state, player)) {
            this.launchDropBlockAsItem(world, pos, state, fortune);
        } else {
            this.func_176226_b(world, pos, state, fortune);
        }
        this.harvesters.set(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldLaunchDrop(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (!(player.field_70163_u > (double)pos.func_177956_o() + 0.5)) return false;
        if (!this.isAttachedToBlock(state, world, pos)) return false;
        Function1<BlockPos, Boolean> isNonSolid$ = new Function1<BlockPos, Boolean>(world){
            final /* synthetic */ World $world;

            public final boolean invoke(@NotNull BlockPos pos) {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                return !this.$world.func_180495_p(pos).func_185904_a().func_76220_a();
            }
            {
                this.$world = world;
                super(1);
            }
        };
        BlockPos blockPos = pos.func_177984_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.up()");
        if (!isNonSolid$.invoke(blockPos)) return false;
        BlockPos blockPos2 = pos.func_177984_a().func_177972_a((EnumFacing)state.func_177229_b((IProperty)Companion.getFACING()));
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.up().offset(state.getValue(FACING))");
        if (!isNonSolid$.invoke(blockPos2)) return false;
        return true;
    }

    public final void launchDropBlockAsItem(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.launchDropBlockAsItemWithChance(world, pos, state, 1.0f, fortune);
    }

    public final void launchDropBlockAsItemWithChance(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, float chance, int fortune) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!world.field_72995_K && !world.restoringBlockSnapshots && world.func_82736_K().func_82766_b("doTileDrops")) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Companion.getFACING());
            List drops = this.getDrops((IBlockAccess)world, pos, state, fortune);
            float actualChance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(world.field_73012_v.nextFloat() <= actualChance)) continue;
                if (((Boolean)BlockClimbingRope.access$getCaptureDrops$p$s64279661().get()).booleanValue()) {
                    ((List)BlockClimbingRope.access$getCapturedDrops$p$s64279661().get()).add(drop);
                    return;
                }
                ItemStack itemStack = drop;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"drop");
                EnumFacing enumFacing = facing;
                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
                this.launchDropAsEntity(world, pos, itemStack, enumFacing);
            }
        }
    }

    public final void launchDropAsEntity(@NotNull World world, @NotNull BlockPos pos, @NotNull ItemStack stack, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        double posX = (double)pos.func_177958_n() + (double)world.field_73012_v.nextFloat() * 0.5 + 0.25;
        double posY = (double)pos.func_177956_o() + (double)world.field_73012_v.nextFloat() * 0.25 + 0.75;
        double posZ = (double)pos.func_177952_p() + (double)world.field_73012_v.nextFloat() * 0.5 + 0.25;
        EntityItem entityitem = new EntityItem(world, posX, posY, posZ, stack);
        entityitem.field_70159_w = (double)facing.func_82601_c() * 0.1;
        entityitem.field_70181_x = 0.3;
        entityitem.field_70179_y = (double)facing.func_82599_e() * 0.1;
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }

    public final void checkAndDropBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!this.isAttached(state, world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public final boolean isAttachedToRope(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        BlockPos blockPos = pos.func_177984_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.up()");
        EnumFacing enumFacing = (EnumFacing)state.func_177229_b((IProperty)Companion.getFACING());
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"state.getValue(FACING)");
        return this.feature.isMatchingBlock(world, blockPos, enumFacing);
    }

    public final boolean isAttachedToBlock(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Companion.getFACING());
        BlockPos attachPos = pos.func_177972_a(facing);
        return world.isSideSolid(attachPos, facing.func_176734_d());
    }

    public final boolean isAttached(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return this.isAttachedToRope(state, world, pos) || this.isAttachedToBlock(state, world, pos);
    }

    @NotNull
    public final ClimbingRope getFeature() {
        return this.feature;
    }

    public BlockClimbingRope(@NotNull ClimbingRope feature) {
        Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
        super(Material.field_151593_r);
        this.feature = feature;
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Companion.getFACING(), (Comparable)EnumFacing.UP));
    }

    static {
        Companion = new Companion(null);
        PropertyDirection propertyDirection = PropertyDirection.func_177712_a((String)"facing", (Predicate)Companion.FACING.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDirection, (String)"PropertyDirection.create\u2026 it != EnumFacing.DOWN })");
        FACING = propertyDirection;
        AxisAlignedBB[] elements$iv = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.25), new AxisAlignedBB(0.375, 0.0, 0.75, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.25, 1.0, 0.625), new AxisAlignedBB(0.75, 0.0, 0.375, 1.0, 1.0, 0.625)};
        boundingBoxes = (AxisAlignedBB[])((Object[])elements$iv);
        elements$iv = new AxisAlignedBB[]{new AxisAlignedBB(0.5, 0.0, 0.5, 0.5, 1.0, 0.5), new AxisAlignedBB(0.5, 0.0, 0.125, 0.5, 1.0, 0.125), new AxisAlignedBB(0.5, 0.0, 0.875, 0.5, 1.0, 0.875), new AxisAlignedBB(0.125, 0.0, 0.5, 0.125, 1.0, 0.5), new AxisAlignedBB(0.875, 0.0, 0.5, 0.875, 1.0, 0.5)};
        collisionBoxes = (AxisAlignedBB[])((Object[])elements$iv);
        elements$iv = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, -0.375, 1.125, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.375), new AxisAlignedBB(-0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.375, 1.0, 1.0)};
        ladderCollisionBoxes = (AxisAlignedBB[])((Object[])elements$iv);
    }

    @Override
    public boolean isIntersectingDefault(@NotNull BlockPos pos, @NotNull EntityLivingBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return ISpecialLadderBlock.DefaultImpls.isIntersectingDefault(this, pos, entity);
    }

    public static final /* synthetic */ ThreadLocal access$getCaptureDrops$p$s64279661() {
        return Block.captureDrops;
    }

    public static final /* synthetic */ void access$setCaptureDrops$p$s64279661(ThreadLocal threadLocal) {
        Block.captureDrops = threadLocal;
    }

    public static final /* synthetic */ ThreadLocal access$getCapturedDrops$p$s64279661() {
        return Block.capturedDrops;
    }

    public static final /* synthetic */ void access$setCapturedDrops$p$s64279661(ThreadLocal threadLocal) {
        Block.capturedDrops = threadLocal;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/jamieswhiteshirt/literalascension/common/block/BlockClimbingRope$Companion;", "", "()V", "FACING", "Lnet/minecraft/block/properties/PropertyDirection;", "getFACING", "()Lnet/minecraft/block/properties/PropertyDirection;", "boundingBoxes", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "getBoundingBoxes", "()[Lnet/minecraft/util/math/AxisAlignedBB;", "[Lnet/minecraft/util/math/AxisAlignedBB;", "collisionBoxes", "getCollisionBoxes", "ladderCollisionBoxes", "getLadderCollisionBoxes", "literal-ascension_main"})
    public static final class Companion {
        @NotNull
        public final PropertyDirection getFACING() {
            return FACING;
        }

        private final AxisAlignedBB[] getBoundingBoxes() {
            return boundingBoxes;
        }

        private final AxisAlignedBB[] getCollisionBoxes() {
            return collisionBoxes;
        }

        private final AxisAlignedBB[] getLadderCollisionBoxes() {
            return ladderCollisionBoxes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

