/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import cofh.api.energy.IEnergyReceiver;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.integration.SonarLoader;
import sonar.core.utils.IGuiTile;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.client.GuiFlux;
import sonar.flux.common.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla")})
public class TileEntityPlug
extends TileEntityFlux
implements IGuiTile,
IEnergyReceiver,
ITeslaConsumer,
IEnergyStorage,
IFluxPlug {
    public TileEntityPlug() {
        super(IFlux.ConnectionType.PLUG);
        this.customName.setDefault((Object)"Flux Plug");
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFlux(player, this, false);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFlux((Container)this.getGuiContainer(player), this, player);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return true;
        }
        if (SonarLoader.teslaLoaded && capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return (T)this;
        }
        if (SonarLoader.teslaLoaded && capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public long givePower(long power, boolean simulated) {
        return this.receiveEnergy(null, (int)Math.min(power, Integer.MAX_VALUE), simulated);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(null, Math.min(maxReceive, Integer.MAX_VALUE), simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

