/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiFluxBase;
import sonar.flux.client.GuiState;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.network.PacketFluxButton;

public class GuiStateNetworkSelect
extends GuiState {
    public SonarScroller scroller;
    public int lastClickX;
    public static int listSize = 10;

    public GuiStateNetworkSelect() {
        super(GuiTypeMessage.NETWORK_SELECT, 176, 166, 128, "network.nav.networks");
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        List<? extends IFluxCommon> networks = flux.getNetworks();
        if (networks.isEmpty()) {
            flux.renderNavigationPrompt("No available networks", "Create a New Network");
            return;
        }
        int start = (int)((float)networks.size() * this.scroller.getCurrentScroll());
        int finish = Math.min(start + listSize, networks.size());
        for (int i = start; i < finish; ++i) {
            IFluxCommon common = networks.get(i);
            if (common == null) continue;
            int xPos = 11;
            int yPos = 8 + 12 * i - 12 * start;
            flux.renderNetwork(common.getNetworkName(), common.getAccessType(), common.getNetworkColour().getRGB(), flux.isSelectedNetwork(networks.get(i)), xPos, yPos);
            flux.bindTexture(GuiFlux.buttons);
            flux.func_73729_b(154, yPos, 56, 0, 12, 12);
        }
        flux.bindTexture(flux.getBackground());
        for (GuiButton button : flux.getButtonList()) {
            int id;
            if (!(button instanceof GuiFluxBase.NetworkButton) || !button.func_146115_a() || (id = button.field_146127_k - 10 + (start = (int)((float)networks.size() * this.scroller.getCurrentScroll()))) >= networks.size()) continue;
            IFluxCommon network = networks.get(id);
            ArrayList<String> strings = new ArrayList<String>();
            if (x > flux.getGuiLeft() + 155) {
                strings.add(TextFormatting.RED + "REMOVE");
            } else {
                strings.add(FontHelper.translate((String)"network.owner") + ": " + TextFormatting.AQUA + network.getCachedPlayerName());
                strings.add(FontHelper.translate((String)"network.accessSetting") + ": " + TextFormatting.AQUA + FontHelper.translate((String)network.getAccessType().getName()));
            }
            flux.func_146283_a(strings, x - flux.getGuiLeft(), y - flux.getGuiTop());
        }
    }

    @Override
    public void init(GuiFlux flux) {
        this.scroller = new SonarScroller(flux.getGuiLeft() + 165, flux.getGuiTop() + 8, 123, 10);
        this.scroller.currentScroll = 0.0f;
        for (int i = 0; i < listSize; ++i) {
            flux.getButtonList().add((GuiButton)new GuiFluxBase.NetworkButton(10 + i, flux.getGuiLeft() + 7, flux.getGuiTop() + 8 + i * 12));
        }
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
        List<? extends IFluxCommon> networks;
        int start;
        int network;
        if (button.field_146127_k >= 10 && (network = (start = (int)((float)(networks = flux.getNetworks()).size() * this.scroller.getCurrentScroll())) + button.field_146127_k - 10) < networks.size()) {
            IFluxCommon common = networks.get(network);
            if (this.lastClickX > flux.getGuiLeft() + 155) {
                FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(PacketFluxButton.Type.DELETE_NETWORK, flux.tile.func_174877_v(), common.getNetworkID()));
            } else {
                flux.setNetwork(common);
            }
        }
    }

    @Override
    public boolean type(GuiFlux flux, char c, int i) {
        if (c == '\b') {
            FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(PacketFluxButton.Type.DELETE_NETWORK, flux.tile.func_174877_v(), flux.getNetworkID()));
            return false;
        }
        return true;
    }

    public int getNetworkPosition(GuiFlux flux) {
        if (flux.common.getNetworkName() == null) {
            return -1;
        }
        List<? extends IFluxCommon> networks = flux.getNetworks();
        if (networks.isEmpty()) {
            return -1;
        }
        int start = (int)((float)networks.size() * this.scroller.getCurrentScroll());
        int finish = Math.min(start + listSize, networks.size());
        for (int i = start; i < finish; ++i) {
            if (networks.get(i) == null || !flux.isSelectedNetwork(networks.get(i))) continue;
            return i - start;
        }
        return -1;
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
        this.lastClickX = x;
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[0];
    }

    @Override
    public SonarScroller[] getScrollers() {
        return new SonarScroller[]{this.scroller};
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        return flux.getNetworks().size();
    }
}

