/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.api.tiles.IFluxStorage;
import sonar.flux.connection.BasicFluxNetwork;
import sonar.flux.connection.FluxHelper;

public class FluxCache<T extends IFluxListenable> {
    public static final FluxCache flux = new FluxCache(IFluxListenable.class){

        @Override
        public void connect(BasicFluxNetwork network, IFluxListenable flux) {
            flux.connect(network);
        }

        @Override
        public void disconnect(BasicFluxNetwork network, IFluxListenable flux) {
            flux.disconnect(network);
        }

        @Override
        public void update(BasicFluxNetwork network) {
            network.setHasConnections(!network.getConnections(this).isEmpty());
            controller.update(network);
            network.updateFluxTallies();
        }
    };
    public static final FluxCache plug = new FluxCache<IFluxPlug>(IFluxPlug.class);
    public static final FluxCache point = new FluxCache<IFluxPoint>(IFluxPoint.class);
    public static final FluxCache storage = new FluxCache(IFluxStorage.class){

        @Override
        public void update(BasicFluxNetwork network) {
            network.resetStorageValues();
        }
    };
    public static final FluxCache controller = new FluxCache(IFluxController.class){

        @Override
        public void update(BasicFluxNetwork network) {
            List controllers = network.getConnections(controller);
            if (controllers.size() > 1) {
                boolean set = false;
                for (IFluxController controller : controllers) {
                    if (set && controller.canTransfer()) {
                        set = true;
                        continue;
                    }
                    controller.disconnect(network);
                }
            }
            if (controllers.size() > 0) {
                IFluxController controller = (IFluxController)controllers.get(0);
                FluxHelper.sortConnections(network.getConnections(plug), controller.getSendMode());
                FluxHelper.sortConnections(network.getConnections(point), controller.getReceiveMode());
            }
        }
    };
    public Class<T> clazz;
    public static final List<FluxCache> types = Lists.newArrayList((Object[])new FluxCache[]{flux, plug, point, storage, controller});

    public FluxCache(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static ArrayList<FluxCache> getValidTypes(IFluxListenable tile) {
        ArrayList valid = Lists.newArrayList();
        for (FluxCache handler : types) {
            if (!handler.clazz.isInstance(tile)) continue;
            valid.add(handler);
        }
        return valid;
    }

    public void update(BasicFluxNetwork network) {
    }

    public void connect(BasicFluxNetwork network, IFluxListenable flux) {
    }

    public void disconnect(BasicFluxNetwork network, IFluxListenable flux) {
    }
}

