/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import shetiphian.core.common.rgb16.RGB16Helper;

public class RGB16 {
    private byte vRed = 0;
    private byte vGreen = 0;
    private byte vBlue = 0;

    public RGB16() {
        this(RGB16Helper.getRandomValues());
    }

    public RGB16(int red, int green, int blue) {
        this(new byte[]{(byte)red, (byte)green, (byte)blue});
    }

    public RGB16(short rgbIndex) {
        this(RGB16Helper.getValuesFrom(rgbIndex));
    }

    public RGB16(String colorName) {
        this(RGB16Helper.getBaseValuesFrom(colorName));
    }

    private RGB16(byte[] values) {
        this.setValues(values[0], values[1], values[2]);
    }

    public RGB16 add(int red, int green, int blue) {
        return this.setValues(this.vRed + red, this.vGreen + green, this.vBlue + blue);
    }

    public RGB16 subtract(int red, int green, int blue) {
        return this.setValues(this.vRed - red, this.vGreen - green, this.vBlue - blue);
    }

    public RGB16 add(String colorName) {
        byte[] values = RGB16Helper.getAdjustValuesFrom(colorName);
        return this.add(values[0], values[1], values[2]);
    }

    public RGB16 subtract(String colorName) {
        byte[] values = RGB16Helper.getAdjustValuesFrom(colorName);
        return this.subtract(values[0], values[1], values[2]);
    }

    private RGB16 setValues(int red, int green, int blue) {
        byte[] values = RGB16Helper.clamp(red, green, blue);
        this.vRed = values[0];
        this.vGreen = values[1];
        this.vBlue = values[2];
        return this;
    }

    public byte[] getValues() {
        return new byte[]{this.vRed, this.vGreen, this.vBlue};
    }

    public short getIndex() {
        return (short)(this.vRed * 256 + this.vGreen * 16 + this.vBlue);
    }

    public int getColor() {
        return -16777216 + (this.vRed * 17 << 16) + (this.vGreen * 17 << 8) + this.vBlue * 17;
    }

    public String getTooltip() {
        return "\u00a7c" + this.vRed + "\u00a7a" + this.vGreen + "\u00a79" + this.vBlue;
    }

    public String toString() {
        return "R:" + this.vRed + "-G:" + this.vGreen + "-B:" + this.vBlue;
    }
}

