/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum SortingHandler implements Function<Action.ActionContext, Void>
{
    INSTANCE;


    @Nullable
    public Void apply(@Nullable Action.ActionContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return null;
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (context.slot.field_75224_c instanceof InventoryCrafting) {
            this.distributeInventory(context, itemcounts);
        } else if (!context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
        return null;
    }

    private void distributeInventory(Action.ActionContext context, Multiset<ItemStackHolder> itemcounts) {
        ItemStackHolder ish;
        ItemStack is;
        int x;
        InventoryCrafting ic = (InventoryCrafting)context.slot.field_75224_c;
        TreeMultiset slotCounts = TreeMultiset.create((Comparator)new InventoryHandler.ItemStackComparator());
        for (int x2 = 0; x2 < ic.func_174922_i(); ++x2) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                ItemStack is2 = ic.func_70463_b(x2, y);
                if (is2 == null) continue;
                slotCounts.add((Object)new ItemStackHolder(is2));
            }
        }
        ImmutableMultiset staticcounts = ImmutableMultiset.copyOf(itemcounts);
        for (x = 0; x < ic.func_174922_i(); ++x) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                is = ic.func_70463_b(x, y);
                if (is == null) continue;
                ish = new ItemStackHolder(is);
                int count = staticcounts.count((Object)ish);
                int slotNum = slotCounts.count((Object)ish);
                int occurrences = count / slotNum;
                itemcounts.remove((Object)ish, occurrences);
                is.field_77994_a = occurrences;
            }
        }
        for (x = 0; x < ic.func_174922_i(); ++x) {
            for (int y = 0; y < ic.func_174923_h(); ++y) {
                is = ic.func_70463_b(x, y);
                if (is == null || itemcounts.count((Object)(ish = new ItemStackHolder(is))) <= 0) continue;
                is.field_77994_a += itemcounts.setCount((Object)ish, 0);
            }
        }
        for (int slot = context.slotMapping.begin; slot < context.slotMapping.end + 1; ++slot) {
            context.player.field_71070_bA.func_75139_a(slot).func_75218_e();
        }
    }

    private void compactInventory(Action.ActionContext context, Multiset<ItemStackHolder> itemcounts) {
        UnmodifiableIterator itemsIterator;
        try {
            itemsIterator = Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Weird, the sorting didn't quite work!", (Object[])new Object[0]);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        for (int i = slotLow; i < slotHigh; ++i) {
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            ItemStack target = null;
            if (itemCount > 0 && stackHolder != null) {
                target = ((ItemStackHolder)stackHolder.getElement()).is.func_77946_l();
                int n = target.field_77994_a = itemCount > target.func_77976_d() ? target.func_77976_d() : itemCount;
            }
            if (target != null && !slot.func_75214_a(target) || !slot.func_82869_a((EntityPlayer)context.player)) continue;
            slot.func_75215_d(target);
            if ((itemCount -= target != null ? target.field_77994_a : 0) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
    }
}

