/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum InventoryHandler {
    INSTANCE;

    public final Method mergeStack = this.getMergeStackMethod();
    static Map<IInventory, ImmutableList<IInventory>> preferredOrders;

    private Method getMergeStackMethod() {
        try {
            Method m = ReflectionHelper.findMethod(Container.class, null, (String[])new String[]{"func_75135_a", "mergeItemStack"}, (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean mergeStack(Container container, ItemStack stack, int low, int high, boolean rev) {
        try {
            return (Boolean)this.mergeStack.invoke((Object)container, stack, low, high, rev);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getItemStack(Action.ActionContext ctx) {
        return this.getItemStack(ctx.slot);
    }

    public ItemStack getItemStack(Slot slot) {
        if (slot.getSlotIndex() < 0) {
            return null;
        }
        return slot.field_75224_c.func_70301_a(slot.getSlotIndex());
    }

    public void moveItemToOtherInventory(Action.ActionContext ctx, ItemStack is, int targetLow, int targetHigh, boolean slotIsDestination) {
        for (int i = targetLow; !(i >= targetHigh || ctx.player.field_71070_bA.func_75139_a(i).func_75214_a(is) && this.mergeStack(ctx.player.field_71070_bA, is, i, i + 1, slotIsDestination)); ++i) {
        }
    }

    public Slot findStackWithItem(ItemStack is, Action.ActionContext ctx) {
        if (is.func_77976_d() == 1) {
            return null;
        }
        List<Map.Entry<IInventory, InventoryMapping>> entries = this.getSortedMapping(ctx);
        for (Map.Entry<IInventory, InventoryMapping> ent : entries) {
            IInventory inv = ent.getKey();
            if (inv == ctx.slotMapping.inv) continue;
            for (int i = ent.getValue().begin; i <= ent.getValue().end; ++i) {
                ItemStack sis;
                Slot slot = ctx.player.field_71070_bA.func_75139_a(i);
                if (!slot.func_82869_a((EntityPlayer)ctx.player) || (sis = slot.func_75211_c()) == null || sis.func_77973_b() != is.func_77973_b() || !ItemStack.func_77970_a((ItemStack)sis, (ItemStack)is)) continue;
                return slot;
            }
        }
        return null;
    }

    List<Map.Entry<IInventory, InventoryMapping>> getSortedMapping(final Action.ActionContext ctx) {
        ArrayList entries = Lists.newArrayList((Iterable)ctx.mapping.entrySet());
        if (preferredOrders.containsKey(ctx.slotMapping.inv)) {
            Collections.sort(entries, new Comparator<Map.Entry<IInventory, InventoryMapping>>(){

                @Override
                public int compare(Map.Entry<IInventory, InventoryMapping> o1, Map.Entry<IInventory, InventoryMapping> o2) {
                    int idx1 = preferredOrders.get(ctx.slotMapping.inv).indexOf((Object)o1.getKey());
                    int idx2 = preferredOrders.get(ctx.slotMapping.inv).indexOf((Object)o2.getKey());
                    return Ints.compare((int)idx1, (int)idx2);
                }
            });
        }
        return entries;
    }

    public Multiset<ItemStackHolder> getInventoryContent(Action.ActionContext context) {
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        TreeMultiset itemcounts = TreeMultiset.create((Comparator)new ItemStackComparator());
        for (int i = slotLow; i < slotHigh; ++i) {
            ItemStack stack;
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            if (!slot.func_82869_a((EntityPlayer)context.player) || (stack = slot.func_75211_c()) == null || stack.func_77973_b() == null) continue;
            ItemStackHolder ish = new ItemStackHolder(stack.func_77946_l());
            itemcounts.add((Object)ish, stack.field_77994_a);
        }
        HashMultiset entries = HashMultiset.create();
        for (Multiset.Entry entry : itemcounts.descendingMultiset().entrySet()) {
            entries.add(entry.getElement(), entry.getCount());
        }
        return entries;
    }

    static {
        preferredOrders = ImmutableMap.of((Object)Action.ActionContext.PLAYER_HOTBAR, (Object)ImmutableList.of((Object)Action.ActionContext.PLAYER_OFFHAND, (Object)Action.ActionContext.PLAYER_MAIN), (Object)Action.ActionContext.PLAYER_OFFHAND, (Object)ImmutableList.of((Object)Action.ActionContext.PLAYER_HOTBAR, (Object)Action.ActionContext.PLAYER_MAIN), (Object)Action.ActionContext.PLAYER_MAIN, (Object)ImmutableList.of((Object)Action.ActionContext.PLAYER_OFFHAND, (Object)Action.ActionContext.PLAYER_HOTBAR));
    }

    public static class InventoryMapping {
        int begin = Integer.MAX_VALUE;
        int end = 0;
        final IInventory inv;
        final IInventory proxy;
        final Container container;
        final Class<? extends Slot> slotType;
        boolean markForRemoval;
        boolean markAsHeterogeneous;

        InventoryMapping(IInventory inv, Container container, IInventory proxy, Class<? extends Slot> slotType) {
            this.inv = inv;
            this.container = container;
            this.proxy = proxy;
            this.slotType = slotType;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("i", (Object)this.inv).add("c", (Object)this.container).add("b", this.begin).add("e", this.end).toString();
        }
    }

    public static class ItemStackComparator
    implements Comparator<ItemStackHolder> {
        @Override
        public int compare(ItemStackHolder o1, ItemStackHolder o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.is.func_77973_b() != o2.is.func_77973_b()) {
                return o1.is.func_77973_b().getRegistryName().toString().compareTo(o2.is.func_77973_b().getRegistryName().toString());
            }
            if (o1.is.func_77960_j() != o2.is.func_77960_j()) {
                return Ints.compare((int)o1.is.func_77960_j(), (int)o2.is.func_77960_j());
            }
            if (ItemStack.func_77970_a((ItemStack)o1.is, (ItemStack)o2.is)) {
                return 0;
            }
            return Ints.compare((int)System.identityHashCode(o1), (int)System.identityHashCode(o2));
        }
    }
}

