/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.inventorysorter.AllItemsHandler;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.items.SlotItemHandler;

public enum Action {
    SORT(SortingHandler.INSTANCE, "middleClickSorting", "Middle-click sorting module", true),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN, "mouseWheelMoving", "Mouse wheel movement module", true),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT, "mouseWheelMoving", "Mouse wheel movement module", true),
    ALL(AllItemsHandler.INSTANCE, "allMoving", "All items movement module - NYI", false);

    private final Function<ActionContext, Void> worker;
    private final String configName;
    private boolean actionActive;
    private Property property;
    private final String comment;
    private final boolean implemented;

    private Action(Function<ActionContext, Void> worker, String configName, String comment, boolean implemented) {
        this.worker = worker;
        this.configName = configName;
        this.comment = comment;
        this.implemented = implemented;
    }

    public static void configure(Configuration config) {
        for (Action a : Action.values()) {
            a.property = config.get("client", a.configName, true);
            a.property.setRequiresMcRestart(false);
            a.property.setRequiresWorldRestart(false);
            a.property.setLanguageKey("inventorysorter.gui." + a.configName);
            a.property.setShowInGui(a.implemented);
            a.property.setComment(a.comment);
            a.actionActive = a.property.getBoolean(true);
        }
    }

    public static Action interpret(KeyHandler.KeyStates keyStates) {
        if (keyStates.isDownClick()) {
            return null;
        }
        if (keyStates.isMiddleMouse()) {
            return SORT;
        }
        if (keyStates.mouseWheelRollingDown()) {
            return ONEITEMIN;
        }
        if (keyStates.mouseWheelRollingUp()) {
            return ONEITEMOUT;
        }
        if (keyStates.isSpace()) {
            return ALL;
        }
        return null;
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.field_75222_d);
    }

    public void execute(ActionContext context) {
        this.worker.apply((Object)context);
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean isActive() {
        return this.actionActive;
    }

    public String getConfigName() {
        return this.configName;
    }

    public static class ActionContext {
        public final Slot slot;
        public final InventoryHandler.InventoryMapping slotMapping;
        public final EntityPlayerMP player;
        public final ImmutableBiMap<IInventory, InventoryHandler.InventoryMapping> mapping;
        public static final IInventory PLAYER_HOTBAR = new InventoryBasic("Dummy Hotbar", false, 0);
        public static final IInventory PLAYER_MAIN = new InventoryBasic("Dummy Main", false, 0);
        public static final IInventory PLAYER_OFFHAND = new InventoryBasic("Dummy Offhand", false, 0);

        public ActionContext(Slot slot, EntityPlayerMP playerEntity) {
            this.slot = slot;
            this.player = playerEntity;
            InventoryHandler.InventoryMapping slotTarget = null;
            HashMap mapping = Maps.newHashMap();
            InventoryHandler.InventoryMapping inventoryMapping = null;
            Container openContainer = playerEntity.field_71070_bA;
            for (Slot sl : openContainer.field_75151_b) {
                if (sl.field_75224_c == null || sl instanceof SlotItemHandler || InventorySorter.INSTANCE.slotblacklist.contains(sl.getClass().getName())) continue;
                if (!mapping.containsKey(sl.field_75224_c)) {
                    mapping.put(sl.field_75224_c, new InventoryHandler.InventoryMapping(sl.field_75224_c, openContainer, sl.field_75224_c, sl.getClass()));
                }
                inventoryMapping = (InventoryHandler.InventoryMapping)mapping.get(sl.field_75224_c);
                if (!(inventoryMapping.slotType == sl.getClass() || inventoryMapping.inv instanceof InventoryPlayer || inventoryMapping.inv instanceof TileEntityFurnace || inventoryMapping.inv instanceof TileEntityBrewingStand)) {
                    inventoryMapping.markForRemoval = true;
                    continue;
                }
                if (inventoryMapping.slotType != sl.getClass()) {
                    inventoryMapping.markAsHeterogeneous = true;
                }
                inventoryMapping.begin = Math.min(sl.field_75222_d, inventoryMapping.begin);
                inventoryMapping.end = Math.max(sl.field_75222_d, inventoryMapping.end);
                if (sl != slot) continue;
                slotTarget = inventoryMapping;
            }
            if (mapping.containsKey(playerEntity.field_71071_by)) {
                InventoryHandler.InventoryMapping playerMapping = (InventoryHandler.InventoryMapping)mapping.remove(playerEntity.field_71071_by);
                if (slotTarget == playerMapping) {
                    slotTarget = null;
                }
                int mainStart = 9;
                int mainEnd = 36;
                int offhandStart = 40;
                InventoryHandler.InventoryMapping hotbarMapping = new InventoryHandler.InventoryMapping(PLAYER_HOTBAR, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
                InventoryHandler.InventoryMapping mainMapping = new InventoryHandler.InventoryMapping(PLAYER_MAIN, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
                InventoryHandler.InventoryMapping offhandMapping = new InventoryHandler.InventoryMapping(PLAYER_OFFHAND, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
                for (int i = playerMapping.begin; i <= playerMapping.end; ++i) {
                    Slot s = openContainer.func_75139_a(i);
                    if (s.getSlotIndex() < mainStart && s.field_75224_c == playerEntity.field_71071_by) {
                        hotbarMapping.begin = Math.min(s.field_75222_d, hotbarMapping.begin);
                        hotbarMapping.end = Math.max(s.field_75222_d, hotbarMapping.end);
                        mapping.put(PLAYER_HOTBAR, hotbarMapping);
                        inventoryMapping = hotbarMapping;
                    } else if (s.getSlotIndex() < mainEnd && s.field_75224_c == playerEntity.field_71071_by) {
                        mainMapping.begin = Math.min(s.field_75222_d, mainMapping.begin);
                        mainMapping.end = Math.max(s.field_75222_d, mainMapping.end);
                        mapping.put(PLAYER_MAIN, mainMapping);
                        inventoryMapping = mainMapping;
                    } else if (s.getSlotIndex() >= offhandStart && s.field_75224_c == playerEntity.field_71071_by) {
                        offhandMapping.begin = Math.min(s.field_75222_d, offhandMapping.begin);
                        offhandMapping.end = Math.max(s.field_75222_d, offhandMapping.end);
                        mapping.put(PLAYER_OFFHAND, offhandMapping);
                        inventoryMapping = offhandMapping;
                    } else {
                        inventoryMapping = null;
                    }
                    if (s != slot) continue;
                    slotTarget = inventoryMapping;
                }
            }
            for (Map.Entry map : Sets.newLinkedHashSet(mapping.entrySet())) {
                if (!((InventoryHandler.InventoryMapping)map.getValue()).markForRemoval) continue;
                mapping.remove(map.getKey());
                if (slotTarget != map.getValue()) continue;
                slotTarget = null;
            }
            this.slotMapping = slotTarget;
            this.mapping = ImmutableBiMap.copyOf((Map)mapping);
        }
    }
}

