/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.terrain;

import eladkay.scanner.Config;
import eladkay.scanner.ScannerMod;
import eladkay.scanner.misc.MessageUpdateEnergyServer;
import eladkay.scanner.misc.NetworkHelper;
import eladkay.scanner.terrain.GuiBuildRemotely;
import eladkay.scanner.terrain.MessageUpdateScanner;
import eladkay.scanner.terrain.TileEntityTerrainScanner;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTerrainScanner
extends GuiContainer {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("scanner:textures/gui/standardBackground.png");
    private final TileEntityTerrainScanner scanner;
    private GuiButton rotate;
    private GuiButton toggleMode;
    private GuiSlider sliderSpeedup;
    private GuiButton showMap;
    private static final ResourceLocation ENERGY_BAR = new ResourceLocation("scanner:textures/gui/bar.png");

    public GuiTerrainScanner(TileEntityTerrainScanner scanner) {
        super(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return true;
            }
        });
        this.scanner = scanner;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.toggleMode = new GuiButton(0, this.field_146294_l / 2 - 75, this.field_146295_m / 2 + 40, 150, 20, "");
        this.rotate = new GuiButton(1, this.field_146294_l / 2 - 75, this.field_146295_m / 2, 150, 20, "");
        this.sliderSpeedup = new GuiSlider(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
                ((GuiTerrainScanner)GuiTerrainScanner.this).scanner.speedup = value < 1.0f ? 1 : (int)value;
                GuiTerrainScanner.this.scanner.func_70296_d();
                MessageUpdateScanner.send(GuiTerrainScanner.this.scanner);
            }

            public void func_175319_a(int id, String value) {
            }
        }, 2, this.field_146294_l / 2 - 75, this.field_146295_m / 2 + 10, "Speed (Blocks/t)", 1.0f, Float.parseFloat(Config.maxSpeedup + ""), (float)this.scanner.speedup, new GuiSlider.FormatHelper(){

            public String func_175318_a(int id, String name, float value) {
                return name + ": " + (int)value;
            }
        });
        this.showMap = new GuiButton(3, this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 15, 150, 20, "Show map");
        this.field_146292_n.add(this.toggleMode);
        this.field_146292_n.add(this.showMap);
        if (Config.maxSpeedup > 0) {
            this.field_146292_n.add(this.sliderSpeedup);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.toggleMode) {
            if (this.scanner.on) {
                this.scanner.deactivate();
            } else {
                this.scanner.activate();
            }
            NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateEnergyServer(this.scanner.func_174877_v().func_177958_n(), this.scanner.func_174877_v().func_177956_o(), this.scanner.func_174877_v().func_177952_p()));
            MessageUpdateScanner.send(this.scanner);
        } else if (button == this.rotate) {
            this.scanner.rotation = this.scanner.rotation.getNext();
            if (this.scanner.on) {
                this.scanner.deactivate();
            }
            this.scanner.current.func_181079_c(this.scanner.func_174877_v().func_177958_n(), 0, this.scanner.func_174877_v().func_177952_p());
            MessageUpdateScanner.send(this.scanner);
        } else if (button == this.showMap) {
            new GuiBuildRemotely(this.scanner).openGui();
        }
    }

    public void drawMultiEnergyBar(int x, int y, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ENERGY_BAR);
        int energyStored = this.scanner.getEnergyStored(null);
        int maxEnergyStored = this.scanner.getMaxEnergyStored(null);
        this.func_73729_b(x, y, -15, -1, 14, 50);
        int draw = (int)((double)energyStored / (double)maxEnergyStored * 48.0);
        this.func_73729_b(x + 1, y + 49 - draw, 0, 48 - draw, 12, draw);
        if (GuiTerrainScanner.isInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiUtils.drawGradientRect((int)0, (int)(x + 1), (int)(y + 1), (int)(x + 13), (int)(y + 49), (int)-2130706433, (int)-2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GOLD + "" + energyStored + "/" + maxEnergyStored + " RF");
            if (GuiTerrainScanner.func_146272_n()) {
                int percentage = energyStored / maxEnergyStored * 100;
                TextFormatting color = percentage <= 10 ? TextFormatting.RED : (percentage >= 75 ? TextFormatting.GREEN : TextFormatting.YELLOW);
                list.add(color + "" + percentage + "%" + TextFormatting.GRAY + " Charged");
            }
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146297_k.field_71466_p);
            GlStateManager.func_179140_f();
        }
    }

    private static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public int getKx() {
        return 0;
    }

    public int getKy() {
        return 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.scanner == null || this.toggleMode == null || this.showMap == null) {
            return;
        }
        this.toggleMode.field_146126_j = this.scanner.on ? "Turn off" : "Turn on";
        boolean flag = false;
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.field_146297_k.field_71441_e.func_180495_p(this.scanner.func_174877_v().func_177972_a(facing)).func_177230_c() != ScannerMod.biomeScannerUltimate) continue;
            flag = true;
        }
        this.showMap.field_146125_m = flag;
        switch (this.scanner.rotation) {
            case POSX_POSZ: {
                this.rotate.field_146126_j = "Build on +x, +z";
                break;
            }
            case POSX_NEGZ: {
                this.rotate.field_146126_j = "Build on +x, -z";
                break;
            }
            case NEGX_POSZ: {
                this.rotate.field_146126_j = "Build on -x, +z";
                break;
            }
            case NEGX_NEGZ: {
                this.rotate.field_146126_j = "Build on -x, -z";
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x - this.field_146289_q.func_78256_a(text) / 2, y, color);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        NetworkHelper.instance.sendToServer((IMessage)new MessageUpdateEnergyServer(this.scanner.func_174877_v().func_177958_n(), this.scanner.func_174877_v().func_177956_o(), this.scanner.func_174877_v().func_177952_p()));
        if (this.field_146297_k.func_71356_B()) {
            this.drawCenteredString("Terrain Scanner", 90 + this.getKx(), 6 + this.getKy(), 0x404040);
        } else {
            this.drawCenteredString("Terrain Scanner", 90 + this.getKx(), 6 + this.getKy(), 0x404040);
            this.drawCenteredString("(Warning: May appear broken with", 90 + this.getKx(), 13 + this.getKy(), 0x404040);
            this.drawCenteredString("EnderIO conduits and capacitor banks)", 90 + this.getKx(), 20 + this.getKy(), 0x404040);
        }
        if (!"(0, -1, 0)".equals("(" + this.scanner.current.func_177958_n() + ", " + this.scanner.current.func_177956_o() + ", " + this.scanner.current.func_177952_p() + ")")) {
            this.drawCenteredString("Current: (" + this.scanner.current.func_177958_n() + ", " + this.scanner.current.func_177956_o() + ", " + this.scanner.current.func_177952_p() + ")", 90 + this.getKx(), 35 + this.getKy(), 0x404040);
        } else {
            this.drawCenteredString("Current block: Off", 90 + this.getKx(), 35 + this.getKy(), 0x404040);
        }
        this.drawCenteredString("End block: (" + this.scanner.getEnd().func_177958_n() + ", " + this.scanner.maxY + ", " + this.scanner.getEnd().func_177952_p() + ")", 90 + this.getKx(), 45 + this.getKy(), 0x404040);
        if (this.scanner.posStart != null) {
            this.drawCenteredString("Remote start: (" + this.scanner.posStart.func_177958_n() + ", " + this.scanner.posStart.func_177952_p() + ")", 90 + this.getKx(), 55 + this.getKy(), 0x404040);
        }
        boolean flag = false;
        for (EnumFacing facing : EnumFacing.values()) {
            if (this.field_146297_k.field_71441_e.func_180495_p(this.scanner.func_174877_v().func_177972_a(facing)).func_177230_c() != ScannerMod.biomeScannerUltimate) continue;
            flag = true;
        }
        if (!flag) {
            this.field_146289_q.func_78276_b("Place ultimate biome scanner", 15 + this.getKx(), 65 + this.getKy(), 0x404040);
            this.field_146289_q.func_78276_b("adjacent to show map", 30 + this.getKx(), 75 + this.getKy(), 0x404040);
        }
        if (this.scanner.queue != null) {
            this.field_146289_q.func_78276_b("Scanner Queue attached", 30 + this.getKx(), 150 + this.getKy(), 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

