/*
 * Decompiled with CFR 0.152.
 */
package eladkay.scanner.misc;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class BaseEnergyContainer
extends EnergyStorage
implements ITeslaHolder,
ITeslaConsumer,
ITeslaProducer,
INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<?> CAPABILITY_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<?> CAPABILITY_PRODUCER = null;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<?> CAPABILITY_HOLDER = null;

    public void setEnergyStored(long energyStored) {
        this.energy = (int)energyStored;
    }

    public BaseEnergyContainer(int capacity) {
        super(capacity);
    }

    public BaseEnergyContainer(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public BaseEnergyContainer(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    @Optional.Method(modid="tesla")
    public long givePower(long tesla, boolean simulate) {
        return this.receiveEnergy((int)tesla & 0xEFFFFFFF, simulate);
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    @Optional.Method(modid="tesla")
    public long takePower(long tesla, boolean simulate) {
        return this.extractEnergy((int)tesla & 0xEFFFFFFF, simulate);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("energy", this.energy);
        compound.func_74768_a("capacity", this.capacity);
        compound.func_74768_a("maxReceive", this.maxReceive);
        compound.func_74768_a("maxExtract", this.maxExtract);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("energy");
        this.capacity = nbt.func_74762_e("capacity");
        this.maxReceive = nbt.func_74762_e("maxReceive");
        this.maxExtract = nbt.func_74762_e("maxExtract");
    }
}

