/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.client.ClientHelper;
import com.teamacronymcoders.base.util.OpenGLHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiHelper
extends GuiScreen {
    private Minecraft mc = Minecraft.func_71410_x();
    private FontRenderer fontRenderer;

    public GuiHelper() {
        this.fontRenderer = this.mc.field_71466_p;
    }

    private void drawWindow(int x, int y, int w, int h, int bgColour) {
        GuiHelper.func_73734_a((int)(x - 3), (int)(y - 4), (int)(x + w + 3), (int)(y - 3), (int)bgColour);
        GuiHelper.func_73734_a((int)(x - 3), (int)(y + h + 3), (int)(x + w + 3), (int)(y + h + 4), (int)bgColour);
        GuiHelper.func_73734_a((int)(x - 3), (int)(y - 3), (int)(x + w + 3), (int)(y + h + 3), (int)bgColour);
        GuiHelper.func_73734_a((int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + h + 3), (int)bgColour);
        GuiHelper.func_73734_a((int)(x + w + 3), (int)(y - 3), (int)(x + w + 4), (int)(y + h + 3), (int)bgColour);
    }

    public void drawWindowWithBorder(int x, int y, int w, int h, int bgColour, int frameColour) {
        this.drawWindow(x, y, w, h, bgColour);
        int frameFade = (frameColour & 0xFEFEFE) >> 1 | frameColour & 0xFF000000;
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + h + 3 - 1, frameColour, frameFade);
        this.func_73733_a(x + w + 2, y - 3 + 1, x + w + 3, y + h + 3 - 1, frameColour, frameFade);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y - 3 + 1, frameColour, frameFade);
        this.func_73733_a(x - 3, y + h + 2, x + w + 3, y + h + 3, frameColour, frameFade);
    }

    public void drawLineOnVerticalProgressBar(int x, int y, int w, int h, int p, int pMax, int lineColor) {
        int lineY = Math.round((float)p / (float)pMax * (float)(h += 4));
        GuiHelper.func_73734_a((int)(x -= 2), (int)((y -= 2) + h - lineY), (int)((w += 4) + x), (int)(y + h - lineY + 1), (int)lineColor);
    }

    public void drawVerticalProgressBar(int x, int y, int w, int h, int p, int bgColour, int frameColour, int progressColour) {
        this.drawProgressBar(x, y, w, h, p, bgColour, frameColour, progressColour, 1);
    }

    public void drawHorizontalProgressBar(int x, int y, int w, int h, int p, int bgColour, int frameColour, int progressColour) {
        this.drawProgressBar(x, y, w, h, p, bgColour, frameColour, progressColour, 0);
    }

    private void drawProgressBar(int x, int y, int w, int h, int p, int bgColour, int frameColour, int progressColour, int hv) {
        this.drawWindowWithBorder(x, y, w, h, bgColour, frameColour);
        x -= 2;
        y -= 2;
        w += 4;
        h += 4;
        switch (hv) {
            case 0: {
                float pWf = (float)w / 100.0f * (float)p;
                int pW = Math.round(pWf);
                GuiHelper.func_73734_a((int)x, (int)y, (int)(x + pW), (int)(y + h), (int)progressColour);
                break;
            }
            case 1: {
                float pHf = (float)h / 100.0f * (float)p;
                int pH = Math.round(pHf);
                GuiHelper.func_73734_a((int)x, (int)(y + h - pH), (int)(w + x), (int)(h + y), (int)progressColour);
                break;
            }
        }
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        int[][] savedGLState = OpenGLHelper.saveGLState(new int[]{3008, 2896});
        RenderItem renderItem = this.mc.func_175599_af();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        renderItem.func_175042_a(itemStack, x, y);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        OpenGLHelper.restoreGLState(savedGLState);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, RenderItem renderItem, boolean transparent) {
        this.field_73735_i = 50.0f;
        renderItem.field_77023_b = 50.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int colorOverlay = new Color(139, 139, 139, 160).hashCode();
        RenderHelper.func_74520_c();
        renderItem.func_180450_b(itemStack, x, y);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        if (transparent) {
            this.field_73735_i = 100.0f;
            renderItem.field_77023_b = 100.0f;
            this.func_73733_a(x, y, x + 16, y + 16, colorOverlay, colorOverlay);
        }
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 0.0f;
        renderItem.field_77023_b = 0.0f;
    }

    public void drawMiniItemStack(ItemStack itemStack, int x, int y) {
        int[][] savedGLState = OpenGLHelper.saveGLState(new int[]{3008, 2896});
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.drawItemStack(itemStack, x, y);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glPopMatrix();
        OpenGLHelper.restoreGLState(savedGLState);
    }

    public void drawDisabledSlot(int x, int y, RenderItem renderItem) {
        this.field_73735_i = 100.0f;
        renderItem.field_77023_b = 100.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int colorOverlay = new Color(139, 139, 139, 200).hashCode();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        renderItem.func_180450_b(new ItemStack(Blocks.field_180401_cv), x, y);
        this.func_73733_a(x, y, x + 16, y + 16, colorOverlay, colorOverlay);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 0.0f;
        renderItem.field_77023_b = 0.0f;
    }

    public void drawCenteredStringWithShadow(int x, int y, int w, String message, int Colour) {
        int messageWidth = this.fontRenderer.func_78256_a(message);
        int messageX = x + ((w >> 1) - (messageWidth >> 1));
        this.fontRenderer.func_175063_a(message, (float)messageX, (float)y, Colour);
    }

    public void drawStringWithShadow(int x, int y, String message, int colour) {
        this.fontRenderer.func_175063_a(message, (float)x, (float)y, colour);
    }

    public void drawCenteredString(int x, int y, int w, String message, int colour) {
        int messageWidth = this.fontRenderer.func_78256_a(message);
        int messageX = x + ((w >> 1) - (messageWidth >> 1));
        this.fontRenderer.func_78276_b(message, messageX, y, colour);
    }

    public void renderSplitString(String str, int x, int y, int wrapWidth, int textColour) {
        int posY = y;
        for (String s : this.fontRenderer.func_78271_c(str, wrapWidth)) {
            this.drawStringWithShadow(x, posY, s, textColour);
            posY += this.fontRenderer.field_78288_b;
        }
    }

    public List<String> getSplitString(String str, int wrapWidth) {
        return this.fontRenderer.func_78271_c(str, wrapWidth);
    }

    public void drawPlayerHead(int x, int y) {
        ResourceLocation playerSkin = ClientHelper.player().func_110306_p();
        this.mc.func_110434_K().func_110577_a(playerSkin);
        int[][] savedGLState = OpenGLHelper.saveGLState(new int[]{3008, 2896});
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0f, (float)0.5f, (float)1.0f);
        this.func_73729_b(x, y, 32, 64, 32, 64);
        this.func_73729_b(x, y, 160, 64, 32, 64);
        GL11.glPopMatrix();
        OpenGLHelper.restoreGLState(savedGLState);
    }

    private void drawPixels(int x, int y, int u, int v, int width, int height, int times) {
        for (int cu = u; cu < u + width; ++cu) {
            for (int cv = v; cv < v + height; ++cv) {
                for (int factor = 0; factor < times; ++factor) {
                    this.func_73729_b(x + cu * 3 + factor, y + cv * 3 + factor, cu + u, cv + v, 1, 1);
                }
            }
        }
    }

    public void drawResource(ResourceLocation resource, int x, int y, int u, int v, int w, int h) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        this.func_73729_b(x, y, u, v, w, h);
    }
}

