/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.items;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.items.ItemBlockGeneric;
import com.teamacronymcoders.base.subblocksystem.blocks.BlockSubBlockHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockSubBlockHolder
extends ItemBlockGeneric<BlockSubBlockHolder>
implements IHasItemColor {
    public ItemBlockSubBlockHolder(BlockSubBlockHolder block) {
        super(block);
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        return tintIndex == 0 ? ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(stack.func_77960_j()).getColor() : -1;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return ((BlockSubBlockHolder)this.getActualBlock()).getSubBlock(stack.func_77960_j()).getLocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ModelResourceLocation> getModelResourceLocations(List<ModelResourceLocation> models) {
        ((BlockSubBlockHolder)this.getActualBlock()).getSubBlocks().forEach((meta, subBlock) -> models.add(new ModelResourceLocation(subBlock.getTextureLocation(), "inventory")));
        return models;
    }

    @Nonnull
    public CreativeTabs[] getCreativeTabs() {
        ArrayList creativeTabsList = Lists.newArrayList();
        ((BlockSubBlockHolder)this.getActualBlock()).getSubBlocks().values().forEach(subBlock -> {
            if (subBlock.getCreativeTab() != null && !creativeTabsList.contains(subBlock.getCreativeTab())) {
                creativeTabsList.add(subBlock.getCreativeTab());
            }
        });
        return creativeTabsList.toArray(new CreativeTabs[creativeTabsList.size()]);
    }
}

