/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    private SimpleNetworkWrapper networkWrapper;
    private int id = -1;

    public PacketHandler(String modid) {
        this.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modid);
    }

    public <I extends IMessage, O extends IMessage> void registerPacket(Class<? extends IMessageHandler<I, O>> messageHandler, Class<I> requestMessageType, Side side) {
        this.networkWrapper.registerMessage(messageHandler, requestMessageType, ++this.id, side);
    }

    public void sendToAllAround(IMessage message, Entity entity) {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 64.0);
        this.sendToAllAround(message, targetPoint);
    }

    public void sendToAllAround(IMessage message, BlockPos blockPos, int dimensionId) {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimensionId, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 64.0);
        this.sendToAllAround(message, targetPoint);
    }

    public void sendToPlayer(IMessage message, EntityPlayerMP entityPlayer) {
        this.networkWrapper.sendTo(message, entityPlayer);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint targetPoint) {
        this.networkWrapper.sendToAllAround(message, targetPoint);
    }

    public void sendToServer(IMessage message) {
        this.networkWrapper.sendToServer(message);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.networkWrapper.sendToDimension(message, dimensionId);
    }
}

