/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.items.IHasOreDict;
import com.teamacronymcoders.base.items.ItemBase;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemMaterialPart
extends ItemBase
implements IHasItemColor,
IHasOreDict,
IHasGeneratedModel {
    private Map<Integer, MaterialPart> itemMaterialParts;
    private MaterialSystem materialSystem;

    public ItemMaterialPart(MaterialSystem materialSystem) {
        super("material_part");
        this.func_77627_a(true);
        this.materialSystem = materialSystem;
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        return modelNames;
    }

    @Override
    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        this.getItemMaterialParts().values().forEach(materialPart -> itemStacks.add(materialPart.getItemStack()));
        return itemStacks;
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack itemStack, int tintIndex) {
        return tintIndex == 0 ? this.getMaterialParkFromItemStack(itemStack).getColor() : -1;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemStack) {
        return this.getMaterialParkFromItemStack(itemStack).getLocalizedName();
    }

    public boolean func_77636_d(@Nonnull ItemStack itemStack) {
        return this.getMaterialParkFromItemStack(itemStack).hasEffect();
    }

    @Nonnull
    private MaterialPart getMaterialParkFromItemStack(ItemStack itemStack) {
        MaterialPart materialPart = this.materialSystem.getMaterialPart(itemStack.func_77952_i());
        return materialPart != null ? materialPart : MaterialSystem.MISSING_MATERIAL_PART;
    }

    public Map<Integer, MaterialPart> getItemMaterialParts() {
        if (this.itemMaterialParts == null) {
            this.itemMaterialParts = new HashMap<Integer, MaterialPart>();
        }
        return this.itemMaterialParts;
    }

    @Override
    @Nonnull
    public Map<ItemStack, String> getOreDictNames(@Nonnull Map<ItemStack, String> names) {
        for (Map.Entry<Integer, MaterialPart> entry : this.getItemMaterialParts().entrySet()) {
            names.put(new ItemStack((Item)this, 1, entry.getKey().intValue()), entry.getValue().getOreDictString());
        }
        return names;
    }

    public void addMaterialPart(int id, MaterialPart materialPart) {
        this.getItemMaterialParts().put(id, materialPart);
    }

    @Override
    public List<ResourceLocation> getResourceLocations(List<ResourceLocation> resourceLocations) {
        this.getItemMaterialParts().forEach((id, materialPart) -> resourceLocations.add(new ResourceLocation(this.materialSystem.getMod().getID(), materialPart.getUnlocalizedName())));
        return resourceLocations;
    }

    @Override
    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        for (MaterialPart materialPart : this.getItemMaterialParts().values()) {
            TemplateFile templateFile = TemplateManager.getTemplateFile("item_model");
            HashMap replacements = Maps.newHashMap();
            replacements.put("texture", "base:items/" + materialPart.getPart().getUnlocalizedName());
            templateFile.replaceContents(replacements);
            models.add(new GeneratedModel(materialPart.getUnlocalizedName(), ModelType.ITEM_MODEL, templateFile.getFileContents()));
        }
        return models;
    }
}

