/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.state.GlStateManagerHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CrystalFXWireless
extends CrystalGLFXBase<TileCrystalBase> {
    private final BlockPos linkTarget;
    private final AxisAlignedBB targetBB;
    private float powerLevel = 0.0f;
    private List<PTracker> trackers = new ArrayList<PTracker>();
    private static final FXHandler BASIC_HANDLER = new FXHandler("textures/particle/energy_beam_basic.png");
    private static final FXHandler WYVERN_HANDLER = new FXHandler("textures/particle/energy_beam_wyvern.png");
    private static final FXHandler DRACONIC_HANDLER = new FXHandler("textures/particle/energy_beam_draconic.png");

    public CrystalFXWireless(World worldIn, TileCrystalBase tile, BlockPos linkTarget) {
        super(worldIn, tile);
        this.field_94054_b = 3 + tile.getTier();
        this.field_70546_d = worldIn.field_73012_v.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget));
        this.linkTarget = linkTarget;
        this.field_94055_c = 1;
        this.texturesPerRow = 8.0f;
        IBlockState state = worldIn.func_180495_p(linkTarget);
        this.targetBB = state.func_185900_c((IBlockAccess)worldIn, linkTarget);
        this.targetBB.func_186664_h(0.05);
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void func_189213_a() {
        if (this.ticksTillDeath-- <= 0) {
            this.func_187112_i();
        }
        this.field_82339_as = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        this.powerLevel = (float)MathHelper.approachExp((double)this.powerLevel, (double)this.fxState, (double)0.05);
        Iterator<PTracker> i = this.trackers.iterator();
        while (i.hasNext()) {
            PTracker next = i.next();
            if (next.ticksActive >= next.travelTime) {
                i.remove();
                continue;
            }
            ++next.ticksActive;
        }
        int ps = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (this.field_70546_d % 2 == 0 && this.powerLevel > this.field_187136_p.nextFloat() && (ps == 0 || ps == 1 && this.field_187136_p.nextInt(3) == 0 || ps == 2 && this.field_187136_p.nextInt(10) == 0)) {
            double travel = 50 + this.field_187136_p.nextInt(50);
            this.trackers.add(new PTracker((int)(travel *= (double)(1.4f - this.powerLevel)), new Vector3(this.targetBB.field_72340_a + this.field_187136_p.nextDouble() * (this.targetBB.field_72336_d - this.targetBB.field_72340_a), this.targetBB.field_72338_b + this.field_187136_p.nextDouble() * (this.targetBB.field_72337_e - this.targetBB.field_72338_b), this.targetBB.field_72339_c + this.field_187136_p.nextDouble() * (this.targetBB.field_72334_f - this.targetBB.field_72339_c))));
        }
        this.field_94054_b = ClientEventHandler.elapsedTicks % 5;
        ++this.field_70546_d;
    }

    @Override
    public void func_180434_a(VertexBuffer buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double scale = 0.08;
        float minU = (float)this.field_94054_b / this.texturesPerRow;
        float maxU = minU + 1.0f / this.texturesPerRow;
        float minV = (float)this.field_94055_c / this.texturesPerRow;
        float maxV = minV + 1.0f / this.texturesPerRow;
        Vector3 source = new Vector3(this.field_187126_f - field_70556_an, this.field_187127_g - field_70554_ao, this.field_187128_h - field_70555_ap);
        Vector3 target = Vector3.fromBlockPos((BlockPos)this.linkTarget).subtract(field_70556_an, field_70554_ao, field_70555_ap);
        for (PTracker tracker : this.trackers) {
            double progress = ((double)tracker.ticksActive + (double)partialTicks) / (double)tracker.travelTime;
            if (progress >= 1.0) continue;
            Vector3 pathVec = target.copy().add(tracker.tOffset).subtract(source);
            pathVec.multiply(progress);
            pathVec.add(source);
            buffer.func_181662_b(pathVec.x - (double)rotationX * scale - (double)rotationXY * scale, pathVec.y - (double)rotationZ * scale, pathVec.z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            buffer.func_181662_b(pathVec.x - (double)rotationX * scale + (double)rotationXY * scale, pathVec.y + (double)rotationZ * scale, pathVec.z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buffer.func_181662_b(pathVec.x + (double)rotationX * scale + (double)rotationXY * scale, pathVec.y + (double)rotationZ * scale, pathVec.z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a((double)minU, (double)minV).func_181675_d();
            buffer.func_181662_b(pathVec.x + (double)rotationX * scale - (double)rotationXY * scale, pathVec.y - (double)rotationZ * scale, pathVec.z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a((double)minU, (double)maxV).func_181675_d();
        }
    }

    private void bufferQuad(VertexBuffer buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, double anim, double dist) {
        buffer.func_181662_b(p1.x, p1.y, p1.z).func_187315_a(0.5, anim).func_181675_d();
        buffer.func_181662_b(p2.x, p2.y, p2.z).func_187315_a(0.5, dist + anim).func_181675_d();
        buffer.func_181662_b(p4.x, p4.y, p4.z).func_187315_a(1.0, dist + anim).func_181675_d();
        buffer.func_181662_b(p3.x, p3.y, p3.z).func_187315_a(1.0, anim).func_181675_d();
    }

    public IGLFXHandler getFXHandler() {
        return this.tile.getTier() == 0 ? BASIC_HANDLER : (this.tile.getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class PTracker {
        public int ticksActive = 0;
        public final int travelTime;
        public final Vector3 tOffset;

        public PTracker(int travelTime, Vector3 tOffset) {
            this.travelTime = travelTime;
            this.tOffset = tOffset;
        }
    }

    public static class FXHandler
    implements IGLFXHandler {
        private String texture;
        private float green;

        public FXHandler(String texture) {
            this.texture = texture;
        }

        public void preDraw(int layer, VertexBuffer vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManagerHelper.pushState();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
            GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            ResourceHelperDE.bindTexture(DEParticles.DE_SHEET);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }

        public void postDraw(int layer, VertexBuffer vertexbuffer, Tessellator tessellator) {
            tessellator.func_78381_a();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManagerHelper.popState();
        }
    }
}

