/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.w3c.dom.Element;

public class DCVSpacer
extends DisplayComponentBase {
    public DCVSpacer(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 8;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (WikiConfig.editMode && this.isMouseOver(mouseX, mouseY)) {
            String text = String.format("[Separator: %s Line%s]", (double)this.ySize / 8.0, this.ySize == 8 ? "" : "s");
            this.drawCenteredString(this.fontRenderer, text, this.xPos + this.xSize / 2, this.yPos + this.ySize / 2 - 4, 65280, true);
        }
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SIZE_+", 0, 0, 20, 12, "+"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Increase Spacer Size (Hold shift for fine adjustment)"}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SIZE_-", 0, 0, 20, 12, "-"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Decrease Spacer Size (Hold shift for fine adjustment)"}));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        int modifier;
        super.onMGuiEvent(eventString, eventElement);
        int n = modifier = GuiScreen.func_146272_n() ? 1 : 8;
        if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("SIZE_+")) {
            this.ySize += modifier;
            this.element.setAttribute("size", String.valueOf(this.ySize));
            this.save();
        } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("SIZE_-")) {
            this.ySize -= modifier;
            if (this.ySize < 4) {
                this.ySize = 4;
            }
            this.element.setAttribute("size", String.valueOf(this.ySize));
            this.save();
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute("size", "8");
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        if (!element.hasAttribute("size")) {
            LogHelper.error("No size found for space in " + this.branch.branchID);
            return;
        }
        this.ySize = Integer.parseInt(element.getAttribute("size"));
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCVSpacer component = new DCVSpacer(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "vSpacer";
        }
    }
}

