/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.capability;

import java.util.List;
import mcp.mobius.waila.addons.HUDHandlerBase;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class HUDHandlerEnergy
extends HUDHandlerBase {
    static final IWailaDataProvider INSTANCE = new HUDHandlerEnergy();

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("capability.energyinfo") || accessor.getTileEntity() == null) {
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("forgeEnergy") && accessor.getTileEntity().hasCapability(CapabilityEnergy.ENERGY, accessor.getSide())) {
            NBTTagCompound energyTag = accessor.getNBTData().func_74775_l("forgeEnergy");
            int stored = energyTag.func_74762_e("stored");
            int capacity = energyTag.func_74762_e("capacity");
            ((ITaggedList)currenttip).add(String.format("%d / %d FE", stored, capacity), "IEnergyStorage");
            return currenttip;
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            NBTTagCompound energyTag = new NBTTagCompound();
            energyTag.func_74768_a("capacity", energyStorage.getMaxEnergyStored());
            energyTag.func_74768_a("stored", energyStorage.getEnergyStored());
            tag.func_74782_a("forgeEnergy", (NBTBase)energyTag);
        }
        return tag;
    }
}

