/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.helper.L10NHelpers;

public class MaximumBlockCountValidator
implements IBlockCountValidator {
    private final int maximumCount;

    @Override
    public L10NHelpers.UnlocalizedString isValid(int count, boolean structureComplete, Block block) {
        if (count <= this.getMaximumCount()) {
            return null;
        }
        return new L10NHelpers.UnlocalizedString("multiblock.cyclopscore.error.blockCount.max", this.getMaximumCount(), new L10NHelpers.UnlocalizedString(block.func_149739_a() + ".name", new Object[0]), count);
    }

    @ConstructorProperties(value={"maximumCount"})
    public MaximumBlockCountValidator(int maximumCount) {
        this.maximumCount = maximumCount;
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximumBlockCountValidator)) {
            return false;
        }
        MaximumBlockCountValidator other = (MaximumBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMaximumCount() == other.getMaximumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximumBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaximumCount();
        return result;
    }

    public String toString() {
        return "MaximumBlockCountValidator(maximumCount=" + this.getMaximumCount() + ")";
    }
}

