/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.api.IHeatEntity;
import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.api.data.RadiationData;
import erogenousbeef.bigreactors.api.data.RadiationPacket;
import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelAssembly;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityReactorFuelRod
extends TileEntityReactorPartBase
implements IRadiationModerator,
IHeatEntity {
    private FuelAssembly _assembly;

    @Override
    public void moderateRadiation(RadiationData data, RadiationPacket radiation) {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = this.getReactorController();
        float heat = reactor.getFuelHeat();
        TileEntityReactorControlRod controlRod = this.getAssemblyControlRod();
        if (null == controlRod) {
            return;
        }
        float controlRodInsertion = Math.min(1.0f, Math.max(0.0f, (float)controlRod.getControlRodInsertion() / 100.0f));
        float baseAbsorption = (float)(1.0 - 0.95 * Math.exp(-10.0 * Math.exp(-0.0022 * (double)heat))) * (1.0f - radiation.hardness / this.getFuelHardnessDivisor());
        float scaledAbsorption = Math.min(1.0f, baseAbsorption * this.getFuelAbsorptionCoefficient());
        float controlRodBonus = (1.0f - scaledAbsorption) * controlRodInsertion * 0.5f;
        float controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5f;
        float radiationAbsorbed = (scaledAbsorption + controlRodBonus) * radiation.intensity;
        float fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * radiation.intensity;
        float fuelModerationFactor = this.getFuelModerationFactor();
        fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= fuelModerationFactor;
        data.fuelRfChange += radiationAbsorbed * 10.0f;
        data.fuelAbsorbedRadiation += fertilityAbsorbed;
    }

    private float getFuelModerationFactor() {
        return 1.5f;
    }

    private float getFuelAbsorptionCoefficient() {
        return 0.5f;
    }

    private float getFuelHardnessDivisor() {
        return 1.0f;
    }

    @Override
    public float getThermalConductivity() {
        return 1.0f;
    }

    @Override
    public boolean isGoodForFrame(IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuelrod_position", new Object[]{this.func_174877_v()});
        return false;
    }

    @Override
    public boolean isGoodForSides(IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuelrod_position", new Object[]{this.func_174877_v()});
        return false;
    }

    @Override
    public boolean isGoodForTop(IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuelrod_position", new Object[]{this.func_174877_v()});
        return false;
    }

    @Override
    public boolean isGoodForBottom(IMultiblockValidator validatorCallback) {
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuelrod_position", new Object[]{this.func_174877_v()});
        return false;
    }

    @Override
    public boolean isGoodForInterior(IMultiblockValidator validatorCallback) {
        return true;
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public float getHeatTransferRate() {
        World world = this.func_145831_w();
        float heatTransferRate = 0.0f;
        BlockPos position = this.func_174877_v();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos targetPosition = position.func_177972_a(dir);
            TileEntity te = world.func_175625_s(targetPosition);
            if (te instanceof TileEntityReactorFuelRod) continue;
            if (te instanceof IHeatEntity) {
                heatTransferRate += ((IHeatEntity)te).getThermalConductivity();
                continue;
            }
            if (world.func_175623_d(targetPosition)) {
                heatTransferRate += 0.05f;
                continue;
            }
            heatTransferRate += this.getConductivityFromBlock(world.func_180495_p(targetPosition));
        }
        return heatTransferRate;
    }

    private float getConductivityFromBlock(IBlockState blockState) {
        ReactorInteriorData interiorData;
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150339_S) {
            interiorData = ReactorInterior.getBlockData("blockIron");
        } else if (block == Blocks.field_150340_R) {
            interiorData = ReactorInterior.getBlockData("blockGold");
        } else if (block == Blocks.field_150484_ah) {
            interiorData = ReactorInterior.getBlockData("blockDiamond");
        } else if (block == Blocks.field_150475_bE) {
            interiorData = ReactorInterior.getBlockData("blockEmerald");
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            interiorData = RadiationHelper.waterData;
        } else {
            Fluid fluid;
            interiorData = ReactorInterior.getBlockData(ItemHelper.stackFrom((IBlockState)blockState, (int)1));
            if (interiorData == null && block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null) {
                interiorData = ReactorInterior.getFluidData(fluid.getName());
            }
        }
        if (interiorData == null) {
            interiorData = RadiationHelper.airData;
        }
        return interiorData.heatConductivity;
    }

    public void linkToAssembly(FuelAssembly assembly) {
        this._assembly = assembly;
    }

    @Nullable
    public FuelAssembly getFuelAssembly() {
        return this._assembly;
    }

    @Nullable
    public TileEntityReactorControlRod getAssemblyControlRod() {
        return null != this._assembly ? this._assembly.getControlRod() : null;
    }
}

