/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.multiblock.structure;

import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import com.valkyrieofnight.valkyrielib.multiblock.structure.MultiBlockStructure;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiBlockContinuousScanner {
    private MultiBlockStructure structure;
    private VLTileController controller;
    private Set<BlockPos> scanned = new HashSet<BlockPos>();
    private Queue<BlockPos> queue = new LinkedList<BlockPos>();
    private World world;
    private int scanRate;

    public MultiBlockContinuousScanner(VLTileController cont, int scanRate) {
        this.controller = cont;
        this.structure = cont.getStructure();
        this.scanRate = scanRate;
        this.world = cont.func_145831_w();
    }

    public void update() {
        for (int i = 0; i < this.scanRate; ++i) {
            this.scan();
        }
    }

    protected void scan() {
        if (this.queue.isEmpty()) {
            this.startQueue();
        }
        BlockPos pos = this.queue.poll();
        if (this.structure.isValidComponent(this.world, this.controller.func_174877_v(), pos)) {
            this.controller.deformMultiblock();
        }
    }

    public void setScanRate(int scanRate) {
        this.scanRate = scanRate;
    }

    protected void startQueue() {
        this.scanned.clear();
        this.queue.clear();
        this.queue.addAll(this.structure.getSlavePositions(this.world, this.controller.func_174877_v(), this.controller.getMBDirectionE()));
    }
}

