/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.item;

import elucent.roots.Roots;
import elucent.roots.capability.mana.ManaProvider;
import elucent.roots.component.ComponentBase;
import elucent.roots.component.ComponentManager;
import elucent.roots.component.EnumCastType;
import elucent.roots.event.SpellCastEvent;
import elucent.roots.item.ItemDruidRobes;
import elucent.roots.network.MessageSpellCastFX;
import elucent.roots.network.PacketHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemCastingBase
extends Item {
    public static SoundEvent castingSound = new SoundEvent(new ResourceLocation("roots:staffCast"));

    public ItemCastingBase(String name, int spellSlots) {
        this.func_77655_b(name);
        this.func_77637_a(Roots.tab);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            return 1.0 - (double)ItemCastingBase.getUses(stack) / (double)ItemCastingBase.getMaxUses(stack);
        }
        return 1.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && ItemCastingBase.getUses(stack) < ItemCastingBase.getMaxUses(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static void createData(ItemStack stack, int spellSlots) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("selected", 1);
        stack.func_77978_p().func_74768_a("numSlots", spellSlots);
        for (int i = 1; i < spellSlots + 1; ++i) {
            stack.func_77978_p().func_74780_a("potency" + i, 0.0);
            stack.func_77978_p().func_74780_a("efficiency" + i, 0.0);
            stack.func_77978_p().func_74780_a("size" + i, 0.0);
            stack.func_77978_p().func_74778_a("effect" + i, "");
            stack.func_77978_p().func_74768_a("maxUses" + i, 0);
            stack.func_77978_p().func_74768_a("uses" + i, 0);
        }
    }

    public double getCost(ComponentBase component, double potency, double efficiency) {
        return (double)((float)component.xpCost + (float)potency * 4.0f) / (0.75 * efficiency + 1.0);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (timeLeft < 71988) {
            this.cast(stack, world, player, player.func_184600_cs());
        }
    }

    public void cast(ItemStack stack, World world, EntityLivingBase player, EnumHand hand) {
        if (stack.func_77942_o()) {
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, castingSound, SoundCategory.PLAYERS, 0.95f + 0.1f * field_77697_d.nextFloat(), 0.95f + 0.1f * field_77697_d.nextFloat(), false);
            ComponentBase comp = ComponentManager.getComponentFromName(ItemCastingBase.getEffect(stack));
            if (comp != null) {
                double potency = ItemCastingBase.getPotency(stack);
                double efficiency = ItemCastingBase.getEfficiency(stack);
                double size = ItemCastingBase.getSize(stack);
                if (((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.HEAD) != null && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.CHEST) != null && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.LEGS) != null && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.FEET) != null && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemDruidRobes && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemDruidRobes && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemDruidRobes && ((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemDruidRobes) {
                    efficiency += 1.0;
                }
                SpellCastEvent event = new SpellCastEvent((EntityPlayer)player, comp, potency, efficiency, size);
                MinecraftForge.EVENT_BUS.post((Event)event);
                potency = event.getPotency();
                efficiency = event.getEfficiency();
                size = event.getSize();
                double cost = this.getCost(comp, potency, efficiency);
                Random random = new Random();
                if (((EntityPlayer)player).hasCapability(ManaProvider.manaCapability, null) && ManaProvider.get((EntityPlayer)player).getMana() >= (float)cost && !event.isCanceled()) {
                    ManaProvider.get((EntityPlayer)player).setMana((EntityPlayer)player, ManaProvider.get((EntityPlayer)player).getMana() - (float)cost);
                    this.doEffect(world, (EntityPlayer)player, comp, ItemCastingBase.getPotency(stack), ItemCastingBase.getEfficiency(stack), ItemCastingBase.getSize(stack));
                    ItemCastingBase.decrementUses(stack, stack.func_77978_p().func_74762_e("numSlots"), player, hand);
                    if (!world.field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSpellCastFX(comp.getName(), (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, player.func_70040_Z()));
                    }
                }
            }
        }
    }

    public static void decrementUses(ItemStack stack, int spellSlots, EntityLivingBase player, EnumHand hand) {
        stack.func_77978_p().func_74768_a("uses" + ItemCastingBase.getSlot(stack), ItemCastingBase.getUses(stack) - 1);
        if (ItemCastingBase.getUses(stack) < 0) {
            ((ItemCastingBase)stack.func_77973_b()).setEffectInSlot(stack, ItemCastingBase.getSlot(stack), "", 0, 0, 0);
            boolean isEmpty = true;
            for (int i = 0; i < spellSlots; ++i) {
                if (stack.func_77978_p().func_74779_i("effect" + i).equals("")) continue;
                isEmpty = false;
            }
            if (((ItemCastingBase)stack.func_77973_b()).destroyWhenEmpty()) {
                player.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, null);
            }
        }
    }

    public boolean destroyWhenEmpty() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77942_o()) {
            ComponentBase comp = ComponentManager.getComponentFromName(ItemCastingBase.getEffect(stack));
            if (comp != null) {
                tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"roots.tooltip.spelltypeheading.name", (Object[])new Object[0]) + ": " + comp.getTextColor() + comp.getEffectName());
                tooltip.add(TextFormatting.RED + "  +" + ItemCastingBase.getPotency(stack) + " " + I18n.func_135052_a((String)"roots.tooltip.spellpotency.name", (Object[])new Object[0]) + ".");
                tooltip.add(TextFormatting.RED + "  +" + ItemCastingBase.getEfficiency(stack) + " " + I18n.func_135052_a((String)"roots.tooltip.spellefficiency.name", (Object[])new Object[0]) + ".");
                tooltip.add(TextFormatting.RED + "  +" + ItemCastingBase.getSize(stack) + " " + I18n.func_135052_a((String)"roots.tooltip.spellsize.name", (Object[])new Object[0]) + ".");
                tooltip.add("");
                tooltip.add(TextFormatting.GOLD + Integer.toString(ItemCastingBase.getUses(stack)) + I18n.func_135052_a((String)"roots.tooltip.usesremaining.name", (Object[])new Object[0]));
            }
        }
    }

    public int getUseCount(double efficiency) {
        return 97 + (int)(48.0 * efficiency);
    }

    public void setEffectInSlot(ItemStack stack, int slot, String effect, int potency, int efficiency, int size) {
        if (slot > stack.func_77978_p().func_74762_e("numSlots")) {
            slot = stack.func_77978_p().func_74762_e("numSlots");
        }
        stack.func_77978_p().func_74778_a("effect" + slot, effect);
        stack.func_77978_p().func_74780_a("potency" + slot, (double)potency);
        stack.func_77978_p().func_74780_a("efficiency" + slot, (double)efficiency);
        stack.func_77978_p().func_74780_a("size" + slot, (double)size);
        stack.func_77978_p().func_74768_a("maxUses" + slot, this.getUseCount(efficiency));
        stack.func_77978_p().func_74768_a("uses" + slot, stack.func_77978_p().func_74762_e("maxUses" + slot));
    }

    public void doEffect(World world, EntityPlayer player, ComponentBase component, double potency, double efficiency, double size) {
        component.doEffect(world, (Entity)player, EnumCastType.SPELL, player.field_70165_t + 3.0 * player.func_70040_Z().field_72450_a, player.field_70163_u + 3.0 * player.func_70040_Z().field_72448_b, player.field_70161_v + 3.0 * player.func_70040_Z().field_72449_c, potency, efficiency, size);
    }

    public static int getSlot(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("selected");
        }
        return 0;
    }

    public static int getMaxUses(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("maxUses" + stack.func_77978_p().func_74762_e("selected"));
    }

    public static int getUses(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("uses" + stack.func_77978_p().func_74762_e("selected"));
    }

    public static double getPotency(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74769_h("potency" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0.0;
    }

    public static double getEfficiency(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74769_h("efficiency" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0.0;
    }

    public static double getSize(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74769_h("size" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0.0;
    }

    public static String getEffect(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("effect" + stack.func_77978_p().func_74762_e("selected"));
        }
        return null;
    }

    public static String getEffect(ItemStack stack, int slot) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("effect" + slot);
        }
        return null;
    }

    public int func_77639_j() {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (stack.func_77942_o() && !player.func_70093_af()) {
            if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("selected", stack.func_77978_p().func_74762_e("selected") + 1);
            if (stack.func_77978_p().func_74762_e("selected") > stack.func_77978_p().func_74762_e("numSlots")) {
                stack.func_77978_p().func_74768_a("selected", 1);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.func_77942_o() && newS.func_77942_o()) {
            if (ItemCastingBase.getEffect(oldS) != ItemCastingBase.getEffect(newS) || oldS.func_77978_p().func_74762_e("selected") != newS.func_77978_p().func_74762_e("selected") || slotChanged) {
                return true;
            }
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (stack.func_77942_o()) {
            ComponentBase comp = ComponentManager.getComponentFromName(ItemCastingBase.getEffect(stack));
            double potency = ItemCastingBase.getPotency(stack);
            double efficiency = ItemCastingBase.getEfficiency(stack);
            double size = ItemCastingBase.getSize(stack);
            if (comp != null) {
                comp.castingAction((EntityLivingBase)((EntityPlayer)player), count, potency, efficiency, size);
                if (field_77697_d.nextBoolean()) {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                }
            }
        }
    }
}

