/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.entity;

import elucent.roots.Roots;
import elucent.roots.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityNetherInfection
extends Entity {
    Entity entity;
    Random random = new Random();
    UUID casterId = null;
    int damage = 15;
    float spinDirection = 1.0f;
    float angle = 0.0f;

    public EntityNetherInfection(World world) {
        super(world);
    }

    public EntityNetherInfection(World world, UUID casterId, Entity entity, int potency, int size) {
        super(world);
        this.casterId = casterId;
        this.entity = entity;
        this.damage = 17 + 6 * potency;
        this.field_70165_t = entity.field_70165_t;
        this.field_70163_u = entity.field_70163_u;
        this.field_70161_v = entity.field_70161_v;
        if (this.random.nextInt(2) == 0) {
            this.spinDirection *= -1.0f;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.casterId != null) {
            if (this.entity != null) {
                this.field_70165_t = this.entity.field_70165_t;
                this.field_70163_u = this.entity.field_70163_u + (double)(this.entity.func_70047_e() / 2.0f);
                this.field_70161_v = this.entity.field_70161_v;
            }
            if (this.entity == null || this.entity.field_70128_L) {
                List entities = this.func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0));
                if (entities.size() == 0) {
                    this.func_70076_C();
                    this.func_130014_f_().func_72900_e((Entity)this);
                } else {
                    int i;
                    ArrayList validTargets = new ArrayList();
                    for (i = 0; i < entities.size(); ++i) {
                        if (((EntityLivingBase)entities.get(i)).func_110124_au().compareTo(this.casterId) == 0) continue;
                        validTargets.add(entities.get(i));
                    }
                    if (validTargets.size() > 0) {
                        this.entity = (Entity)validTargets.get(this.random.nextInt(validTargets.size()));
                        for (i = 0; i < 40; ++i) {
                            float coeff = (float)i / 40.0f;
                            this.field_70165_t = this.field_70165_t * (1.0 - (double)coeff) + this.entity.field_70165_t * (double)coeff;
                            this.field_70163_u = this.field_70163_u * (1.0 - (double)coeff) + (this.entity.field_70163_u + (double)(this.entity.func_70047_e() / 2.0f)) * (double)coeff;
                            this.field_70161_v = this.field_70161_v * (1.0 - (double)coeff) + this.entity.field_70161_v * (double)coeff;
                            if (this.random.nextInt(2) == 0) {
                                Roots.proxy.spawnParticleMagicAuraFX(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, 166.0, 37.0, 48.0);
                                continue;
                            }
                            Roots.proxy.spawnParticleMagicAuraFX(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, 92.0, 21.0, 26.0);
                        }
                    } else {
                        this.func_70076_C();
                        this.func_130014_f_().func_72900_e((Entity)this);
                    }
                }
            } else if (this.entity instanceof EntityLivingBase && this.field_70173_aa % 8 == 0) {
                if (this.random.nextInt(6) == 0) {
                    this.spinDirection *= -1.0f;
                }
                this.entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
                --this.damage;
                if (this.damage <= 0) {
                    this.func_70076_C();
                    this.func_130014_f_().func_72900_e((Entity)this);
                }
            }
            this.angle += 4.0f * this.spinDirection;
            for (float i = 0.0f; i < 360.0f; i += 120.0f) {
                Vec3d moveVec = Util.lookVector((float)Math.toRadians(this.angle + i), 0.0f).func_186678_a(0.2);
                if (this.random.nextInt(2) == 0) {
                    Roots.proxy.spawnParticleMagicAuraFX(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, moveVec.field_72450_a, moveVec.field_72448_b, moveVec.field_72449_c, 166.0, 37.0, 48.0);
                    continue;
                }
                Roots.proxy.spawnParticleMagicAuraFX(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, moveVec.field_72450_a, moveVec.field_72448_b, moveVec.field_72449_c, 92.0, 21.0, 26.0);
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.damage = compound.func_74762_e("damage");
        this.casterId = new UUID(compound.func_74763_f("UUIDMost"), compound.func_74763_f("UUIDLeast"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("damage", this.damage);
        compound.func_74772_a("UUIDMost", this.casterId.getMostSignificantBits());
        compound.func_74772_a("UUIDLeast", this.casterId.getLeastSignificantBits());
    }
}

