/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.research.techtree;

import com.valkyrieofnight.environmentaltech.research.techtree.action.Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TechNode {
    private static String UNLOC_BASE_TITLE = "technode.title.environmentaltech.";
    private static String UNLOC_BASE_DESC = "technode.desc.environmentaltech.";
    private static String DEFAULT_TITLE = UNLOC_BASE_TITLE + "default";
    private static String DEFAULT_DESC = UNLOC_BASE_DESC + "default";
    private final String baseName;
    private final String unlocalizedTitle;
    private final String unlocalizedDescription;
    private List<TechNode> requiredNodes;
    private HashMap<Action, Boolean> requiredActions;
    private boolean unlocked;

    public TechNode() {
        this(DEFAULT_TITLE);
    }

    public TechNode(String title) {
        this(title, DEFAULT_DESC);
    }

    public TechNode(String title, String desc) {
        this(title, desc, false);
    }

    public TechNode(String title, String desc, boolean unlocked) {
        this.baseName = title;
        this.unlocalizedTitle = UNLOC_BASE_TITLE + title;
        this.unlocalizedDescription = UNLOC_BASE_DESC + desc;
        this.unlocked = unlocked;
        this.requiredNodes = new ArrayList<TechNode>();
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public boolean canUnlock() {
        for (TechNode techNode : this.requiredNodes) {
            if (techNode.isUnlocked()) continue;
            return false;
        }
        return true;
    }

    public void unlock() {
        if (this.canUnlock()) {
            this.unlocked = true;
        }
    }

    public void forceSetUnlocked(boolean opt) {
        this.unlocked = opt;
    }

    public void addRequirement(TechNode node) {
        this.requiredNodes.add(node);
    }

    public String getBaseName() {
        return this.baseName;
    }
}

