/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.core;

import com.valkyrieofnight.environmentaltech.tileentity.multiblock.lightning.TileContLightningBase;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.solar.TileContSolarBase;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.ore.ContVoidOreMinerT1;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.ore.ContVoidOreMinerT2;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.ore.ContVoidOreMinerT3;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.ore.ContVoidOreMinerT4;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.res.ContVoidResMinerT1;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.res.ContVoidResMinerT2;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.res.ContVoidResMinerT3;
import com.valkyrieofnight.environmentaltech.tileentity.multiblock.voidminer.res.ContVoidResMinerT4;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ETConfig {
    public static final String CONFIG_LOC = "config/environmentaltech/";
    private static Configuration oreConfig;
    private static File oldOreFileLocation;
    private static File oregenConfigFile;
    private static File worldgenConfigFile;
    public static EnumRecipeSet RECIPE_SET;
    public static boolean enableHardenedStoneGeneration;
    public static int hardenedStoneNodes;
    public static int hardenedStoneNodeSize;
    public static int hardenedStoneMinHeight;
    public static int hardenedStoneMaxHeight;
    public static boolean enableAlabasterGeneration;
    public static int alabasterNodes;
    public static int alabasterNodeSize;
    public static int alabasterMinHeight;
    public static int alabasterMaxHeight;
    public static boolean enableBasaltGeneration;
    public static int basaltNodes;
    public static int basaltNodeSize;
    public static int basaltMinHeight;
    public static int basaltMaxHeight;
    private static File clientConfigFile;
    private static Configuration clientConfig;
    public static boolean enableBeamPulse;
    private static File machineConfigFile;
    private static Configuration machineConfig;
    private static Configuration genConfig;
    private static File genConfigFile;
    public static boolean giveGuideOnSpawn;
    public static boolean allowMachineCFGDel;

    public static void preInit() {
        ETConfig.loadGeneralConfig();
        ETConfig.loadOreConfig();
    }

    public static void init() {
        ETConfig.loadMachineConfig();
    }

    public static void loadGeneralConfig() {
        genConfig = new Configuration(genConfigFile);
        if (genConfigFile.exists()) {
            genConfig.load();
        }
        giveGuideOnSpawn = genConfig.getBoolean("giveGuideOnSpawn", "General", giveGuideOnSpawn, "Give a guide to player on first spawn?");
        allowMachineCFGDel = genConfig.getBoolean("deletOldMachineConfig", "General", allowMachineCFGDel, "This will allow Environmental Tech to replace an out of date machine.cfg with new ones. Disable this if you have customized machine.cfg.");
        if (!genConfigFile.exists() || genConfig.hasChanged()) {
            genConfig.save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ETConfig.loadClientConfig();
    }

    @SideOnly(value=Side.CLIENT)
    private static void loadClientConfig() {
        clientConfig = new Configuration(clientConfigFile);
        if (clientConfigFile.exists()) {
            clientConfig.load();
        }
        enableBeamPulse = clientConfig.getBoolean("PulsatingBeam", "Void_Miners", enableBeamPulse, "This will cause the beam to only render when machine is mining. Can flicker fast when machine has speed modifiers. By default it renders when the machine is constructed correctly");
        if (!clientConfigFile.exists() || clientConfig.hasChanged()) {
            clientConfig.save();
        }
    }

    private static void loadOreConfig() {
        if (!worldgenConfigFile.exists() && oldOreFileLocation.exists()) {
            oldOreFileLocation.renameTo(worldgenConfigFile);
        }
        if (!worldgenConfigFile.exists() && oregenConfigFile.exists()) {
            oregenConfigFile.renameTo(worldgenConfigFile);
        }
        oreConfig = new Configuration(worldgenConfigFile);
        if (worldgenConfigFile.exists()) {
            oreConfig.load();
        }
        RECIPE_SET = EnumRecipeSet.SIMPLE;
        enableHardenedStoneGeneration = oreConfig.getBoolean("genHardenedStone", "WorldGen", true, "Enables Generation of Hardened Stone between world heighs of: 0 and 12");
        hardenedStoneNodes = oreConfig.getInt("hardenedStoneTotalNodes", "WorldGen", hardenedStoneNodes, 0, 32, "Total spawns of Hardened Stone in each chunk");
        hardenedStoneNodeSize = oreConfig.getInt("hardenedStoneNodeSize", "WorldGen", hardenedStoneNodeSize, 0, 128, "Size of each spawn of Hardened Stone");
        hardenedStoneMinHeight = oreConfig.getInt("hardenedStoneMinHeight", "WorldGen", hardenedStoneMinHeight, 0, 64, "Min height of Hardened Stone");
        hardenedStoneMaxHeight = oreConfig.getInt("hardenedStoneMaxHeight", "WorldGen", hardenedStoneMaxHeight, 0, 255, "Max height of Hardened Stone");
        hardenedStoneMinHeight = Math.min(64, Math.max(hardenedStoneMinHeight, 0));
        hardenedStoneMaxHeight = Math.max(0, Math.min(hardenedStoneMaxHeight, 255));
        enableAlabasterGeneration = oreConfig.getBoolean("genAlabaster", "WorldGen", true, "Enables Generation of Alabaster between world heighs of: 44 and 200");
        alabasterNodes = oreConfig.getInt("alabasterTotalNodes", "WorldGen", alabasterNodes, 0, 32, "Total spawns of Alabaster in each chunk");
        alabasterNodeSize = oreConfig.getInt("alabasterNodeSize", "WorldGen", alabasterNodeSize, 0, 64, "Size of each spawn of Alabaster");
        alabasterMinHeight = oreConfig.getInt("alabasterMinHeight", "WorldGen", alabasterMinHeight, 0, 64, "Min height of Alabaster");
        alabasterMaxHeight = oreConfig.getInt("alabasterMaxHeight", "WorldGen", alabasterMaxHeight, 0, 255, "Max height of Alabaster");
        alabasterMinHeight = Math.min(64, Math.max(alabasterMinHeight, 0));
        alabasterMaxHeight = Math.max(0, Math.min(alabasterMaxHeight, 255));
        enableBasaltGeneration = oreConfig.getBoolean("genBasalt", "WorldGen", true, "Enables Generation of Basalt between world heighs of: 8 and 32");
        basaltNodes = oreConfig.getInt("basaltTotalNodes", "WorldGen", basaltNodes, 0, 32, "Total spawns of Basalt in each chunk");
        basaltNodeSize = oreConfig.getInt("basaltNodeSize", "WorldGen", basaltNodeSize, 0, 64, "Size of each spawn of Basalt");
        basaltMinHeight = oreConfig.getInt("basaltMinHeight", "WorldGen", basaltMinHeight, 0, 64, "Min height of Basalt");
        basaltMaxHeight = oreConfig.getInt("basaltMaxHeight", "WorldGen", basaltMaxHeight, 0, 255, "Max height of Basalt");
        basaltMinHeight = Math.min(64, Math.max(basaltMinHeight, 0));
        basaltMaxHeight = Math.max(0, Math.min(basaltMaxHeight, 255));
        if (!worldgenConfigFile.exists() || oreConfig.hasChanged()) {
            oreConfig.save();
        }
    }

    private static void loadMachineConfig() {
        String version = "1.1a";
        Configuration temp = new Configuration(machineConfigFile, version);
        if (machineConfigFile.exists()) {
            if (allowMachineCFGDel) {
                temp.load();
                if (!temp.getDefinedConfigVersion().equalsIgnoreCase(temp.getLoadedConfigVersion())) {
                    machineConfigFile.delete();
                    machineConfig = new Configuration(machineConfigFile, version);
                } else {
                    machineConfig = temp;
                }
            } else {
                machineConfig = new Configuration(machineConfigFile, version);
                machineConfig.load();
            }
        }
        TileContSolarBase.PRODUCTION_RATE = machineConfig.getInt("perCellBaseRate", "SolarArray", TileContSolarBase.PRODUCTION_RATE, 72, 8192, "This is the T1 per cell rate. All other tiers are generated automatically");
        TileContLightningBase.baseAmmount = machineConfig.getInt("perStrikeBaseRate", "LightningRod", TileContLightningBase.baseAmmount, 100000, 100000000, "This is the T1 lightning rod. All other tiers are generated based off of this value.");
        ContVoidOreMinerT1.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidOreMinerT1", ContVoidOreMinerT1.ENERGY_COST, 0, 10000000, "Cost per ore mined");
        ContVoidOreMinerT2.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidOreMinerT2", ContVoidOreMinerT2.ENERGY_COST, 0, 10000000, "Cost per ore mined");
        ContVoidOreMinerT3.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidOreMinerT3", ContVoidOreMinerT3.ENERGY_COST, 0, 10000000, "Cost per ore mined");
        ContVoidOreMinerT4.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidOreMinerT4", ContVoidOreMinerT4.ENERGY_COST, 0, 10000000, "Cost per ore mined");
        ContVoidResMinerT1.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidResMinerT1", ContVoidResMinerT1.ENERGY_COST, 0, 100000, "Cost per resource mined");
        ContVoidResMinerT2.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidResMinerT2", ContVoidResMinerT2.ENERGY_COST, 0, 100000, "Cost per resource mined");
        ContVoidResMinerT3.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidResMinerT3", ContVoidResMinerT3.ENERGY_COST, 0, 100000, "Cost per resource mined");
        ContVoidResMinerT4.ENERGY_COST = machineConfig.getInt("energyPerDuration", "VoidResMinerT4", ContVoidResMinerT4.ENERGY_COST, 0, 100000, "Cost per resource mined");
        if (!machineConfigFile.exists() || machineConfig.hasChanged() || !machineConfig.getDefinedConfigVersion().equalsIgnoreCase(machineConfig.getLoadedConfigVersion())) {
            machineConfig.save();
        }
    }

    static {
        oldOreFileLocation = new File("config/environmentaltech.cfg");
        oregenConfigFile = new File("config/environmentaltech/ores.cfg");
        worldgenConfigFile = new File("config/environmentaltech/worldgen.cfg");
        hardenedStoneNodes = 12;
        hardenedStoneNodeSize = 30;
        hardenedStoneMinHeight = 0;
        hardenedStoneMaxHeight = 12;
        alabasterNodes = 22;
        alabasterNodeSize = 30;
        alabasterMinHeight = 40;
        alabasterMaxHeight = 200;
        basaltNodes = 14;
        basaltNodeSize = 28;
        basaltMinHeight = 8;
        basaltMaxHeight = 32;
        clientConfigFile = new File("config/environmentaltech/client.cfg");
        enableBeamPulse = false;
        machineConfigFile = new File("config/environmentaltech/machines.cfg");
        genConfigFile = new File("config/environmentaltech/general.cfg");
        giveGuideOnSpawn = true;
        allowMachineCFGDel = true;
    }

    public static enum EnumRecipeSet {
        SIMPLE,
        ADVANCED;

    }
}

