/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.io;

import com.feed_the_beast.ftbl.lib.io.RequestMethod;
import com.feed_the_beast.ftbl.lib.io.Response;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpConnection {
    public final RequestMethod type;
    public final String url;
    public byte[] data;

    public HttpConnection(RequestMethod t, String s) {
        this.type = t;
        this.url = s;
    }

    public Response connect() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.type == RequestMethod.FILE) {
            FileInputStream is = new FileInputStream(this.url);
            return new Response(RequestMethod.FILE, System.currentTimeMillis() - startTime, 200, is);
        }
        HttpURLConnection con = (HttpURLConnection)new URL(this.url).openConnection();
        con.setRequestMethod(this.type.name());
        con.setRequestProperty("User-Agent", "HTTP/1.1");
        con.setDoInput(true);
        if (this.data != null && this.data.length > 0) {
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(this.data, 0, this.data.length);
            os.flush();
            os.close();
        }
        int responseCode = con.getResponseCode();
        return new Response(this.type, System.currentTimeMillis() - startTime, responseCode, con.getInputStream());
    }
}

