/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.ButtonGuidePage;
import com.feed_the_beast.ftbl.lib.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class GuideContentsLine
extends EmptyGuidePageLine {
    private final GuidePage page;

    public GuideContentsLine(GuidePage p) {
        this.page = p;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new PanelGuideContents((GuiGuide)gui);
    }

    @Override
    public IGuideTextLine copy(GuidePage page) {
        return new GuideContentsLine(page);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("contents"));
        return o;
    }

    @Override
    public boolean isEmpty() {
        return this.page.childPages.isEmpty();
    }

    private class PanelGuideContents
    extends Panel {
        private final List<Widget> buttons;

        private PanelGuideContents(GuiGuide gui) {
            super(0, 0, 10, 10);
            this.buttons = new ArrayList<Widget>();
            this.addButtons(gui, GuideContentsLine.this.page, 0);
        }

        private void addButtons(GuiGuide gui, GuidePage from, int level) {
            this.setWidth(10000);
            for (GuidePage p : from.childPages.values()) {
                ButtonGuidePage w = new ButtonGuidePage(gui, p, true);
                w.posX = level * 12;
                w.width = 1000;
                this.buttons.add(w);
                this.addButtons(gui, p, level + 1);
            }
        }

        @Override
        public void addWidgets() {
            this.addAll(this.buttons);
            this.updateWidgetPositions();
        }

        @Override
        public void updateWidgetPositions() {
            this.setHeight(this.align(WidgetLayout.VERTICAL));
        }
    }
}

