/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.config.PropertyEnumAbstract;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PropertyStringEnum
extends PropertyBase {
    private List<String> keys;
    private String value;

    public PropertyStringEnum() {
        this(Collections.emptyList(), "");
    }

    public PropertyStringEnum(Collection<String> k, String v) {
        this.keys = new ArrayList<String>(k);
        this.value = v;
    }

    public String func_176610_l() {
        return "enum";
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getString();
    }

    public void setString(String v) {
        this.value = v;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return !this.value.equals("-");
    }

    @Override
    public int getInt() {
        return this.keys.indexOf(this.value);
    }

    @Override
    public IConfigValue copy() {
        return new PropertyStringEnum(this.keys, this.getString());
    }

    @Override
    public Color4I getColor() {
        return PropertyEnumAbstract.COLOR;
    }

    @Override
    public List<String> getVariants() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public void onClicked(IGuiEditConfig gui, IConfigKey key, IMouseButton button) {
        this.setString(this.keys.get(MathUtils.wrap(this.getInt() + (button.isLeft() ? 1 : -1), this.keys.size())));
        gui.onChanged(key, this.func_151003_a());
    }

    public void func_152753_a(JsonElement json) {
        this.setString(json.getAsString());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getString());
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.keys.size());
        for (String s : this.keys) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)s);
        }
        data.writeShort(this.getInt());
    }

    @Override
    public void readData(ByteBuf data) {
        this.keys.clear();
        int s = data.readUnsignedShort();
        while (--s >= 0) {
            this.keys.add(ByteBufUtils.readUTF8String((ByteBuf)data));
        }
        this.setString(this.keys.get(data.readUnsignedShort()));
    }
}

