/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.guide;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonObject;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;

public class SpecialGuideButton {
    public final ITextComponent title;
    public final IDrawableObject icon;
    public final ClickEvent clickEvent;

    public SpecialGuideButton(ITextComponent t, IDrawableObject icn, ClickEvent c) {
        this.title = t;
        this.icon = icn;
        this.clickEvent = c;
    }

    public SpecialGuideButton(JsonObject o) {
        this.title = o.has("title") ? JsonUtils.deserializeTextComponent(o.get("title")) : new TextComponentString("");
        this.icon = o.has("icon") ? ImageProvider.get(o.get("icon")) : ImageProvider.NULL;
        this.clickEvent = o.has("click") ? JsonUtils.deserializeClickEvent(o.get("click")) : null;
    }

    public JsonObject serialize() {
        JsonObject o = new JsonObject();
        o.add("title", JsonUtils.serializeTextComponent(this.title));
        o.add("icon", this.icon.getJson());
        if (this.clickEvent != null) {
            o.add("click", JsonUtils.serializeClickEvent(this.clickEvent));
        }
        return o;
    }
}

