/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.implementations.prebaker;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javassist.ClassPool;
import javassist.CtClass;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import reborncore.mixin.MixinManager;
import reborncore.mixin.api.Rewrite;
import reborncore.mixin.json.JsonUtil;
import reborncore.mixin.transformer.IMixinRemap;
import reborncore.mixin.transformer.MixinTransformer;

public class MixinPrebaker {
    private static boolean isSprinkledAnnotation(String desc) {
        return desc.startsWith("Lorg/spongepowered/asm/mixin/transformer/meta");
    }

    public static byte[] desprinkle(byte[] cls) {
        ClassReader reader = new ClassReader(cls);
        ClassWriter writer = new ClassWriter(0);
        reader.accept((ClassVisitor)new DesprinklingClassVisitor(327680, (ClassVisitor)writer), 0);
        return writer.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("usage: MixinPrebaker <mixin-config> <input-jar> <output-jar> <lib-jars...>");
            return;
        }
        MixinPrebaker mixinPrebaker = new MixinPrebaker();
        for (int i = 3; i < args.length; ++i) {
            mixinPrebaker.addFile(new File(args[i]));
        }
        MixinManager.registerMixinConfig(JsonUtil.mixinConfigurationFromFile(new File(args[0])));
        MixinPrebaker.preBake(new File(args[1]), new File(args[2]));
    }

    public static void preBake(File inputJar, File outputJar) {
        MixinManager.mixinRemaper = new DummyRemapper();
        MixinManager.logger = LogManager.getLogger((String)"MixinPrebaker");
        URLClassLoader ucl = (URLClassLoader)MixinPrebaker.class.getClassLoader();
        Launch.classLoader = new LaunchClassLoader(ucl.getURLs());
        Launch.blackboard = new HashMap();
        MixinTransformer mixinTransformer = new MixinTransformer();
        if (outputJar.exists()) {
            outputJar.delete();
        }
        try {
            JarEntry entry;
            JarInputStream input = new JarInputStream(new FileInputStream(inputJar));
            JarOutputStream output = new JarOutputStream(new FileOutputStream(outputJar));
            while ((entry = input.getNextJarEntry()) != null) {
                if (entry.getName().endsWith(".class")) {
                    String className;
                    byte[] classOut;
                    byte[] classIn = ByteStreams.toByteArray((InputStream)input);
                    if (classIn != (classOut = mixinTransformer.transform(className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.'), className, classIn))) {
                        System.out.println("Transformed " + className);
                        classOut = MixinPrebaker.desprinkle(classOut);
                    }
                    JarEntry newEntry = new JarEntry(entry.getName());
                    newEntry.setComment(entry.getComment());
                    newEntry.setSize(classOut.length);
                    newEntry.setLastModifiedTime(FileTime.from(Instant.now()));
                    output.putNextEntry(newEntry);
                    output.write(classOut);
                    continue;
                }
                output.putNextEntry(entry);
                ByteStreams.copy((InputStream)input, (OutputStream)output);
            }
            input.close();
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFile(File file) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)this.getClass().getClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, file.toURI().toURL());
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                System.out.println(t.getMessage());
            }
            throw new IOException("Error, could not add File to system classloader");
        }
    }

    public static class DummyRemapper
    implements IMixinRemap {
        @Override
        public void remap(CtClass mixinClass, ClassPool classPool) {
        }

        @Override
        public Optional<Pair<String, String>> getFullTargetName(Rewrite rewriteAnn, String name) {
            return Optional.empty();
        }
    }

    private static class DesprinklingClassVisitor
    extends ClassVisitor {
        public DesprinklingClassVisitor(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return new DesprinklingFieldVisitor(327680, super.visitField(access, name, desc, signature, value));
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new DesprinklingMethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (MixinPrebaker.isSprinkledAnnotation(desc)) {
                return null;
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    private static class DesprinklingMethodVisitor
    extends MethodVisitor {
        public DesprinklingMethodVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (MixinPrebaker.isSprinkledAnnotation(desc)) {
                return null;
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    private static class DesprinklingFieldVisitor
    extends FieldVisitor {
        public DesprinklingFieldVisitor(int api, FieldVisitor fv) {
            super(api, fv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (MixinPrebaker.isSprinkledAnnotation(desc)) {
                return null;
            }
            return super.visitAnnotation(desc, visible);
        }
    }
}

