/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.RecipeHelper;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.Blueprint;
import vswe.stevescarts.upgrades.CombustionFuel;
import vswe.stevescarts.upgrades.Deployer;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.FuelCapacity;
import vswe.stevescarts.upgrades.FuelCost;
import vswe.stevescarts.upgrades.InputChest;
import vswe.stevescarts.upgrades.InterfaceEffect;
import vswe.stevescarts.upgrades.InventoryEffect;
import vswe.stevescarts.upgrades.Manager;
import vswe.stevescarts.upgrades.Recharger;
import vswe.stevescarts.upgrades.Redstone;
import vswe.stevescarts.upgrades.Solar;
import vswe.stevescarts.upgrades.TankEffect;
import vswe.stevescarts.upgrades.ThermalFuel;
import vswe.stevescarts.upgrades.TimeFlat;
import vswe.stevescarts.upgrades.TimeFlatCart;
import vswe.stevescarts.upgrades.TimeFlatRemoved;
import vswe.stevescarts.upgrades.Transposer;
import vswe.stevescarts.upgrades.WorkEfficiency;

public class AssemblerUpgrade {
    private static HashMap<Byte, AssemblerUpgrade> upgrades = new HashMap();
    private List<Pair<Object[][], Integer>> recipes = new ArrayList<Pair<Object[][], Integer>>();
    private byte id;
    private int sideTexture;
    private String name;
    private ArrayList<BaseEffect> effects;
    private String icon;

    public static HashMap<Byte, AssemblerUpgrade> getUpgrades() {
        return upgrades;
    }

    public static Collection<AssemblerUpgrade> getUpgradesList() {
        return upgrades.values();
    }

    public static AssemblerUpgrade getUpgrade(int id) {
        return upgrades.get((byte)id);
    }

    public static void init() {
        AssemblerUpgrade batteries = new AssemblerUpgrade(0, "Batteries").addEffect(new FuelCapacity(5000)).addEffect(new Recharger(40)).addRecipe(new Object[][]{{Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax}, {Items.field_151137_ax, Items.field_151045_i, Items.field_151137_ax}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
        new AssemblerUpgrade(1, "Power Crystal").addEffect(new FuelCapacity(15000)).addEffect(new Recharger(150)).addRecipe(new Object[][]{{Items.field_151045_i, Items.field_151114_aO, Items.field_151045_i}, {Items.field_151114_aO, Blocks.field_150475_bE, Items.field_151114_aO}, {Items.field_151045_i, batteries.getItemStack(), Items.field_151045_i}});
        AssemblerUpgrade knowledge = new AssemblerUpgrade(2, "Module knowledge").addEffect(new TimeFlat(-750)).addEffect(new TimeFlatCart(-5000)).addEffect(new WorkEfficiency(-0.01f)).addRecipe(new Object[][]{{Items.field_151122_aG, Blocks.field_150342_X, Items.field_151122_aG}, {Blocks.field_150342_X, Blocks.field_150381_bn, Blocks.field_150342_X}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        new AssemblerUpgrade(3, "Industrial espionage").addEffect(new TimeFlat(-2500)).addEffect(new TimeFlatCart(-14000)).addEffect(new WorkEfficiency(-0.01f)).addRecipe(new Object[][]{{Blocks.field_150342_X, ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150342_X}, {ComponentTypes.EYE_OF_GALGADOR.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.EYE_OF_GALGADOR.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), knowledge.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        ItemStack[] books = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            books[i] = Items.field_151134_bR.func_92111_a(new EnchantmentData(Enchantments.field_185305_q, i + 1));
        }
        AssemblerUpgrade experienced = new AssemblerUpgrade(4, "Experienced assembler").addEffect(new WorkEfficiency(0.1f)).addEffect(new FuelCost(0.3f)).addRecipe(new Object[][]{{ComponentTypes.SIMPLE_PCB.getItemStack(), books[0], ComponentTypes.SIMPLE_PCB.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{Items.field_151137_ax, books[1], Items.field_151137_ax}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{Items.field_151137_ax, books[2], Items.field_151137_ax}, {Items.field_151042_j, ComponentTypes.ADVANCED_PCB.getItemStack(), Items.field_151042_j}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{null, books[3], null}, {Items.field_151042_j, ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151042_j}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}}).addRecipe(new Object[][]{{null, books[4], null}, {null, Items.field_151137_ax, null}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(5, "New Era").addEffect(new WorkEfficiency(1.0f)).addEffect(new FuelCost(30.0f)).addRecipe(new Object[][]{{ComponentTypes.GALGADORIAN_METAL.getItemStack(), books[4], ComponentTypes.GALGADORIAN_METAL.getItemStack()}, {ComponentTypes.GALGADORIAN_METAL.getItemStack(), ComponentTypes.ADVANCED_PCB, ComponentTypes.GALGADORIAN_METAL.getItemStack()}, {ComponentTypes.GALGADORIAN_METAL.getItemStack(), experienced.getItemStack(), ComponentTypes.GALGADORIAN_METAL.getItemStack()}});
        new AssemblerUpgrade(6, "CO2 friendly").addEffect(new FuelCost(-0.15f)).addRecipe(new Object[][]{{null, Blocks.field_150331_J, null}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_180407_aO, ComponentTypes.SIMPLE_PCB.getItemStack()}, {ComponentTypes.CLEANING_FAN, ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.CLEANING_FAN}});
        new AssemblerUpgrade(7, "Generic engine").addEffect(new CombustionFuel()).addEffect(new FuelCost(0.05f)).addRecipe(new Object[][]{{null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}, {Blocks.field_150331_J, Blocks.field_150460_al, Blocks.field_150331_J}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(8, "Module input", 1).addEffect(new InputChest(7, 3)).addRecipe(new Object[][]{{null, ComponentTypes.ADVANCED_PCB.getItemStack(), null}, {Blocks.field_150331_J, Blocks.field_150486_ae, Blocks.field_150331_J}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(9, "Production line").addEffect(new Blueprint()).addRecipe(new Object[][]{{null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}, {ComponentTypes.ADVANCED_PCB.getItemStack(), Items.field_151137_ax, ComponentTypes.ADVANCED_PCB.getItemStack()}, {ComponentTypes.REINFORCED_METAL.getItemStack(), ComponentTypes.BLANK_UPGRADE.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack()}});
        new AssemblerUpgrade(10, "Cart Deployer").addEffect(new Deployer()).addRecipe(new Object[][]{{Items.field_151042_j, Blocks.field_150448_aq, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150331_J, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(11, "Cart Modifier").addEffect(new Disassemble()).addRecipe(new Object[][]{{Items.field_151042_j, null, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150467_bQ, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(12, "Cart Crane").addEffect(new Transposer()).addRecipe(new Object[][]{{Blocks.field_150331_J, Blocks.field_150448_aq, Blocks.field_150331_J}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151042_j, ComponentTypes.SIMPLE_PCB.getItemStack()}, {null, ComponentTypes.BLANK_UPGRADE.getItemStack(), null}});
        new AssemblerUpgrade(13, "Redstone Control").addEffect(new Redstone()).addRecipe(new Object[][]{{ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151107_aW, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Blocks.field_150429_aA, ComponentTypes.ADVANCED_PCB.getItemStack(), Blocks.field_150429_aA}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
        new AssemblerUpgrade(14, "Creative Mode").addEffect(new WorkEfficiency(10000.0f)).addEffect(new FuelCost(-1.0f));
        AssemblerUpgrade demolisher = new AssemblerUpgrade(15, "Quick Demolisher").addEffect(new TimeFlatRemoved(-8000)).addRecipe(new Object[][]{{Blocks.field_150343_Z, ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150343_Z}, {ComponentTypes.REINFORCED_METAL.getItemStack(), Blocks.field_150339_S, ComponentTypes.REINFORCED_METAL.getItemStack()}, {Blocks.field_150343_Z, ComponentTypes.BLANK_UPGRADE.getItemStack(), Blocks.field_150343_Z}});
        new AssemblerUpgrade(16, "Entropy").addEffect(new TimeFlatRemoved(-32000)).addEffect(new TimeFlat(3000)).addRecipe(new Object[][]{{ComponentTypes.EYE_OF_GALGADOR.getItemStack(), ComponentTypes.REINFORCED_METAL.getItemStack(), null}, {Items.field_151045_i, Blocks.field_150368_y, Items.field_151045_i}, {null, demolisher.getItemStack(), ComponentTypes.EYE_OF_GALGADOR.getItemStack()}});
        new AssemblerUpgrade(17, "Manager Bridge").addEffect(new Manager()).addEffect(new TimeFlatCart(200)).addRecipe(new Object[][]{{Items.field_151042_j, Items.field_151079_bi, Items.field_151042_j}, {ComponentTypes.SIMPLE_PCB.getItemStack(), ModBlocks.EXTERNAL_DISTRIBUTOR.getBlock(), ComponentTypes.SIMPLE_PCB.getItemStack()}, {Items.field_151042_j, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151042_j}});
        new AssemblerUpgrade(18, "Thermal Engine").addEffect(new ThermalFuel()).addEffect(new FuelCost(0.05f)).addRecipe(new Object[][]{{Blocks.field_150385_bj, ComponentTypes.ADVANCED_PCB.getItemStack(), Blocks.field_150385_bj}, {Blocks.field_150331_J, Blocks.field_150460_al, Blocks.field_150331_J}, {Blocks.field_150343_Z, ComponentTypes.BLANK_UPGRADE.getItemStack(), Blocks.field_150343_Z}});
        new AssemblerUpgrade(19, "Solar Panel").addEffect(new Solar()).addRecipe(new Object[][]{{ComponentTypes.SOLAR_PANEL.getItemStack(), ComponentTypes.SOLAR_PANEL.getItemStack(), ComponentTypes.SOLAR_PANEL.getItemStack()}, {Items.field_151045_i, Items.field_151137_ax, Items.field_151045_i}, {Items.field_151137_ax, ComponentTypes.BLANK_UPGRADE.getItemStack(), Items.field_151137_ax}});
    }

    public AssemblerUpgrade(int id, String name) {
        this(id, name, 0);
    }

    public AssemblerUpgrade(int id, String name, int sideTexture) {
        this.id = (byte)id;
        this.sideTexture = sideTexture;
        this.name = name;
        this.effects = new ArrayList();
        upgrades.put(this.id, this);
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return I18n.func_74838_a((String)("item.SC2:" + this.getRawName() + ".name"));
    }

    public AssemblerUpgrade addEffect(BaseEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public AssemblerUpgrade addRecipe(int resultCount, Object[][] recipe) {
        this.recipes.add((Pair<Object[][], Integer>)Pair.of((Object)recipe, (Object)resultCount));
        return this;
    }

    public AssemblerUpgrade addRecipe(Object[][] recipe) {
        return this.addRecipe(1, recipe);
    }

    public static void initRecipes() {
        for (AssemblerUpgrade update : AssemblerUpgrade.getUpgrades().values()) {
            for (Pair<Object[][], Integer> recipePair : update.recipes) {
                RecipeHelper.addRecipe(update.getItemStack((Integer)recipePair.getRight()), (Object[][])recipePair.getLeft());
            }
        }
    }

    protected ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    protected ItemStack getItemStack(int count) {
        return new ItemStack((Item)ModItems.upgrades, count, (int)this.id);
    }

    public ArrayList<BaseEffect> getEffects() {
        return this.effects;
    }

    public boolean useStandardInterface() {
        return this.getInterfaceEffect() == null;
    }

    public int getInventorySize() {
        InventoryEffect inv = this.getInventoryEffect();
        if (inv != null) {
            return inv.getInventorySize();
        }
        return 0;
    }

    public InterfaceEffect getInterfaceEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof InterfaceEffect)) continue;
            return (InterfaceEffect)effect;
        }
        return null;
    }

    public InventoryEffect getInventoryEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof InventoryEffect)) continue;
            return (InventoryEffect)effect;
        }
        return null;
    }

    public TankEffect getTankEffect() {
        for (BaseEffect effect : this.effects) {
            if (!(effect instanceof TankEffect)) continue;
            return (TankEffect)effect;
        }
        return null;
    }

    public void init(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.init(upgrade);
        }
    }

    public void load(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        for (BaseEffect effect : this.effects) {
            effect.load(upgrade, compound);
        }
    }

    public void save(TileEntityUpgrade upgrade, NBTTagCompound compound) {
        for (BaseEffect effect : this.effects) {
            effect.save(upgrade, compound);
        }
    }

    public void update(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.update(upgrade);
        }
    }

    public void removed(TileEntityUpgrade upgrade) {
        for (BaseEffect effect : this.effects) {
            effect.removed(upgrade);
        }
    }

    public String getRawName() {
        return this.name.replace(":", "").replace(" ", "_").toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

