/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.storages.chests;

import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotChest;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.storages.ModuleStorage;

public abstract class ModuleChest
extends ModuleStorage {
    private float chestAngle;
    private DataParameter<Boolean> IS_OPEN;

    public ModuleChest(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        this.handleChest();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotChest(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    public float getChestAngle() {
        return this.chestAngle;
    }

    protected boolean lidClosed() {
        return this.chestAngle <= 0.0f;
    }

    protected float getLidSpeed() {
        return 0.15707964f;
    }

    protected float chestFullyOpenAngle() {
        return 1.3744469f;
    }

    protected boolean hasVisualChest() {
        return true;
    }

    protected boolean playChestSound() {
        return this.hasVisualChest();
    }

    @Override
    public int numberOfDataWatchers() {
        if (this.hasVisualChest()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void initDw() {
        if (this.hasVisualChest()) {
            this.IS_OPEN = this.createDw(DataSerializers.field_187198_h);
            this.registerDw(this.IS_OPEN, false);
        }
    }

    public void openChest() {
        if (this.hasVisualChest()) {
            this.updateDw(this.IS_OPEN, true);
        }
    }

    public void closeChest() {
        if (this.hasVisualChest()) {
            this.updateDw(this.IS_OPEN, false);
        }
    }

    protected boolean isChestActive() {
        if (!this.hasVisualChest()) {
            return false;
        }
        if (this.isPlaceholder()) {
            return this.getSimInfo().getChestActive();
        }
        return this.getDw(this.IS_OPEN);
    }

    protected void handleChest() {
        if (!this.hasVisualChest()) {
            return;
        }
        if (!this.isChestActive() || !this.lidClosed() || this.playChestSound()) {
            // empty if block
        }
        if (this.isChestActive() && this.chestAngle < this.chestFullyOpenAngle()) {
            this.chestAngle += this.getLidSpeed();
            if (this.chestAngle > this.chestFullyOpenAngle()) {
                this.chestAngle = this.chestFullyOpenAngle();
            }
        } else if (!this.isChestActive() && !this.lidClosed()) {
            float lastAngle = this.chestAngle;
            this.chestAngle -= this.getLidSpeed();
            if (!((double)this.chestAngle < 1.1780972450961724) || !((double)lastAngle >= 1.1780972450961724) || this.playChestSound()) {
                // empty if block
            }
            if (this.chestAngle < 0.0f) {
                this.chestAngle = 0.0f;
            }
        }
    }

    public boolean isCompletelyFilled() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isCompletelyEmpty() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null) continue;
            return false;
        }
        return true;
    }
}

