/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumParticleTypes;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.engines.ModuleEngine;

public abstract class ModuleCoalBase
extends ModuleEngine {
    private int fireCoolDown;
    private int fireIndex;
    private DataParameter<Integer> PRIORITY;

    public ModuleCoalBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected DataParameter<Integer> getPriorityDw() {
        return this.PRIORITY;
    }

    @Override
    public void initDw() {
        this.PRIORITY = this.createDw(DataSerializers.field_187192_b);
        super.initDw();
    }

    @Override
    protected void loadFuel() {
        int consumption = this.getCart().getConsumption(true) * 2;
        if (this.getFuelLevel() <= consumption) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                this.setFuelLevel(this.getFuelLevel() + SlotFuel.getItemBurnTime(this, this.getStack(i)));
                if (this.getFuelLevel() <= consumption) continue;
                if (this.getStack(i) == null) break;
                if (this.getStack(i).func_77973_b().hasContainerItem(this.getStack(i))) {
                    this.setStack(i, new ItemStack(this.getStack(i).func_77973_b().func_77668_q()));
                } else {
                    ItemStack stack = this.getStack(i);
                    --stack.field_77994_a;
                }
                if (this.getStack((int)i).field_77994_a != 0) break;
                this.setStack(i, null);
                break;
            }
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null) continue;
            totalfuel += SlotFuel.getItemBurnTime(this, this.getStack(i)) * this.getStack((int)i).field_77994_a;
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
        double oX = 0.0;
        double oZ = 0.0;
        if (this.getCart().field_70159_w != 0.0) {
            oX = this.getCart().field_70159_w > 0.0 ? -1 : 1;
        }
        if (this.getCart().field_70179_y != 0.0) {
            oZ = this.getCart().field_70179_y > 0.0 ? -1 : 1;
        }
        if (this.getCart().field_70146_Z.nextInt(2) == 0) {
            this.getCart().field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.getCart().field_70165_t + oX * 0.85, this.getCart().field_70163_u + 0.12, this.getCart().field_70161_v + oZ * 0.85, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getCart().field_70146_Z.nextInt(30) == 0) {
            this.getCart().field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.getCart().field_70165_t + oX * 0.75, this.getCart().field_70163_u + 0.15, this.getCart().field_70161_v + oZ * 0.75, this.getCart().field_70159_w, this.getCart().field_70181_x, this.getCart().field_70179_y, new int[0]);
        }
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFuel(this.getCart(), slotId, 8 + x * 18, 23 + 18 * y);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ENGINES.COAL.translate(new String[0]), 8, 6, 0x404040);
        String strfuel = Localization.MODULES.ENGINES.NO_FUEL.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = Localization.MODULES.ENGINES.FUEL.translate(String.valueOf(this.getFuelLevel()));
        }
        this.drawString(gui, strfuel, 8, 42, 0x404040);
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
            if (this.getFuelLevel() < 0) {
                this.setFuelLevel(this.getFuelLevel() + 65536);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.fireCoolDown <= 0) {
            this.fireIndex = this.getCart().field_70146_Z.nextInt(4) + 1;
            this.fireCoolDown = 2;
        } else {
            --this.fireCoolDown;
        }
    }

    public int getFireIndex() {
        if (this.getCart().isEngineBurning()) {
            return this.fireIndex;
        }
        return 0;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74777_a(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.func_74765_d(this.generateNBTName("Fuel", id)));
        if (this.getFuelLevel() < 0) {
            this.setFuelLevel(this.getFuelLevel() + 65536);
        }
    }

    public abstract double getFuelMultiplier();
}

