/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotEnchantment;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.EnchantmentData;
import vswe.stevescarts.helpers.EnchantmentInfo;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleAddon;

public class ModuleEnchants
extends ModuleAddon {
    private EnchantmentData[] enchants = new EnchantmentData[3];
    private ArrayList<EnchantmentInfo.ENCHANTMENT_TYPE> enabledTypes = new ArrayList();

    public ModuleEnchants(EntityMinecartModular cart) {
        super(cart);
    }

    public int getFortuneLevel() {
        if (this.useSilkTouch()) {
            return 0;
        }
        return this.getEnchantLevel(EnchantmentInfo.fortune);
    }

    public boolean useSilkTouch() {
        return false;
    }

    public int getUnbreakingLevel() {
        return this.getEnchantLevel(EnchantmentInfo.unbreaking);
    }

    public int getEfficiencyLevel() {
        return this.getEnchantLevel(EnchantmentInfo.efficiency);
    }

    public int getPowerLevel() {
        return this.getEnchantLevel(EnchantmentInfo.power);
    }

    public int getPunchLevel() {
        return this.getEnchantLevel(EnchantmentInfo.punch);
    }

    public boolean useFlame() {
        return this.getEnchantLevel(EnchantmentInfo.flame) > 0;
    }

    public boolean useInfinity() {
        return this.getEnchantLevel(EnchantmentInfo.infinity) > 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotEnchantment(this.getCart(), this.enabledTypes, slotId, 8, 14 + y * 20);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                if (this.getStack(i) == null || this.getStack((int)i).field_77994_a <= 0) continue;
                int stacksize = this.getStack((int)i).field_77994_a;
                this.enchants[i] = EnchantmentInfo.addBook(this.enabledTypes, this.enchants[i], this.getStack(i));
                if (this.getStack((int)i).field_77994_a == stacksize) continue;
                boolean valid = true;
                for (int j = 0; j < 3; ++j) {
                    if (i == j || this.enchants[i] == null || this.enchants[j] == null || this.enchants[i].getEnchantment() != this.enchants[j].getEnchantment()) continue;
                    this.enchants[i] = null;
                    ItemStack stack = this.getStack(i);
                    ++stack.field_77994_a;
                    valid = false;
                    break;
                }
                if (!valid || this.getStack((int)i).field_77994_a > 0) continue;
                this.setStack(i, null);
            }
        }
    }

    public void damageEnchant(EnchantmentInfo.ENCHANTMENT_TYPE type, int dmg) {
        for (int i = 0; i < 3; ++i) {
            if (this.enchants[i] == null || this.enchants[i].getEnchantment().getType() != type) continue;
            this.enchants[i].damageEnchant(dmg);
            if (this.enchants[i].getValue() > 0) continue;
            this.enchants[i] = null;
        }
    }

    private int getEnchantLevel(EnchantmentInfo info) {
        if (info != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.enchants[i] == null || this.enchants[i].getEnchantment() != info) continue;
                return this.enchants[i].getLevel();
            }
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/enchant.png");
        for (int i = 0; i < 3; ++i) {
            int[] box = this.getBoxRect(i);
            if (this.inRect(x, y, box)) {
                this.drawImage(gui, box, 65, 0);
            } else {
                this.drawImage(gui, box, 0, 0);
            }
            EnchantmentData data = this.enchants[i];
            if (data == null) continue;
            int maxlevel = data.getEnchantment().getEnchantment().func_77325_b();
            int value = data.getValue();
            for (int j = 0; j < maxlevel; ++j) {
                int[] bar = this.getBarRect(i, j, maxlevel);
                if (j != maxlevel - 1) {
                    this.drawImage(gui, bar[0] + bar[2], bar[1], 61 + j, 1, 1, bar[3]);
                }
                int levelmaxvalue = data.getEnchantment().getValue(j + 1);
                if (value > 0) {
                    float mult = value / levelmaxvalue;
                    if (mult > 1.0f) {
                        mult = 1.0f;
                    }
                    int[] array = bar;
                    int n = 2;
                    array[2] = array[2] * (int)mult;
                    this.drawImage(gui, bar, 1, 13 + 11 * j);
                }
                value -= levelmaxvalue;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.enchants[i];
            String str = data != null ? data.getInfoText() : Localization.MODULES.ADDONS.ENCHANT_INSTRUCTION.translate(new String[0]);
            this.drawStringOnMouseOver(gui, str, x, y, this.getBoxRect(i));
        }
    }

    private int[] getBoxRect(int id) {
        return new int[]{40, 17 + id * 20, 61, 12};
    }

    private int[] getBarRect(int id, int barid, int maxlevel) {
        int width = (59 - (maxlevel - 1)) / maxlevel;
        return new int[]{41 + (width + 1) * barid, 18 + id * 20, width, 10};
    }

    @Override
    public int numberOfGuiData() {
        return 9;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        for (int i = 0; i < 3; ++i) {
            EnchantmentData data = this.enchants[i];
            if (data == null) {
                this.updateGuiData(info, i * 3 + 0, (short)-1);
                continue;
            }
            this.updateGuiData(info, i * 3 + 0, (short)Enchantment.func_185258_b((Enchantment)data.getEnchantment().getEnchantment()));
            this.updateGuiData(info, i * 3 + 1, (short)(data.getValue() & 0xFFFF));
            this.updateGuiData(info, i * 3 + 2, (short)(data.getValue() >> 16 & 0xFFFF));
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        int dataint = data;
        if (dataint < 0) {
            dataint += 65536;
        }
        int enchantId = id / 3;
        if ((id %= 3) == 0) {
            this.enchants[enchantId] = data == -1 ? null : EnchantmentInfo.createDataFromEffectId(this.enchants[enchantId], (short)data);
        } else if (this.enchants[enchantId] != null) {
            if (id == 1) {
                this.enchants[enchantId].setValue(this.enchants[enchantId].getValue() & 0xFFFF0000 | dataint);
            } else if (id == 2) {
                this.enchants[enchantId].setValue(this.enchants[enchantId].getValue() & 0xFFFF | dataint << 16);
            }
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        for (int i = 0; i < 3; ++i) {
            if (this.enchants[i] == null) {
                tagCompound.func_74777_a(this.generateNBTName("EffectId" + i, id), (short)-1);
                continue;
            }
            tagCompound.func_74777_a(this.generateNBTName("EffectId" + i, id), (short)Enchantment.func_185258_b((Enchantment)this.enchants[i].getEnchantment().getEnchantment()));
            tagCompound.func_74768_a(this.generateNBTName("Value" + i, id), this.enchants[i].getValue());
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        for (int i = 0; i < 3; ++i) {
            short effect = tagCompound.func_74765_d(this.generateNBTName("EffectId" + i, id));
            if (effect == -1) {
                this.enchants[i] = null;
                continue;
            }
            this.enchants[i] = EnchantmentInfo.createDataFromEffectId(this.enchants[i], effect);
            if (this.enchants[i] == null) continue;
            this.enchants[i].setValue(tagCompound.func_74762_e(this.generateNBTName("Value" + i, id)));
        }
    }

    @Override
    public int guiWidth() {
        return 110;
    }

    public void addType(EnchantmentInfo.ENCHANTMENT_TYPE type) {
        this.enabledTypes.add(type);
    }
}

