/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleAddon;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleDrillIntelligence
extends ModuleAddon {
    private ModuleDrill drill;
    private boolean hasHeightController;
    private int guiW = -1;
    private int guiH = -1;
    private short[] isDisabled;
    private boolean clickedState;
    private boolean clicked;
    private int lastId;

    public ModuleDrillIntelligence(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void preInit() {
        super.preInit();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrill) {
                this.drill = (ModuleDrill)module;
                continue;
            }
            if (!(module instanceof ModuleHeightControl)) continue;
            this.hasHeightController = true;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    private int getDrillWidth() {
        if (this.drill == null) {
            return 0;
        }
        return this.drill.getAreaWidth();
    }

    private int getDrillHeight() {
        if (this.drill == null) {
            return 0;
        }
        return this.drill.getAreaHeight() + (this.hasHeightController ? 2 : 0);
    }

    @Override
    public int guiWidth() {
        if (this.guiW == -1) {
            this.guiW = Math.max(15 + this.getDrillWidth() * 10 + 5, 93);
        }
        return this.guiW;
    }

    @Override
    public int guiHeight() {
        if (this.guiH == -1) {
            this.guiH = 20 + this.getDrillHeight() * 10 + 5;
        }
        return this.guiH;
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/intelligence.png");
        int w = this.getDrillWidth();
        int h = this.getDrillHeight();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int[] rect = this.getSettingRect(i, j);
                int srcX = !this.hasHeightController || j != 0 && j != h - 1 ? 0 : 8;
                int srcY = 0;
                this.drawImage(gui, rect, srcX, srcY);
                if (this.isActive(j * w + i)) {
                    srcX = this.isLocked(j * w + i) ? 8 : 0;
                    srcY = 8;
                    this.drawImage(gui, rect, srcX, srcY);
                }
                srcX = this.inRect(x, y, rect) ? 8 : 0;
                srcY = 16;
                this.drawImage(gui, rect, srcX, srcY);
            }
        }
    }

    private void initDisabledData() {
        if (this.isDisabled == null) {
            this.isDisabled = new short[(int)Math.ceil((float)(this.getDrillWidth() * this.getDrillHeight()) / 16.0f)];
        }
    }

    public boolean isActive(int x, int y, int offset, boolean direction) {
        y = this.getDrillHeight() - 1 - y;
        if (this.hasHeightController) {
            y -= offset;
        }
        if (!direction) {
            x = this.getDrillWidth() - 1 - x;
        }
        return this.isActive(y * this.getDrillWidth() + x);
    }

    private boolean isActive(int id) {
        this.initDisabledData();
        return this.isLocked(id) || (this.isDisabled[id / 16] & 1 << id % 16) == 0;
    }

    private boolean isLocked(int id) {
        int x = id % this.getDrillWidth();
        int y = id / this.getDrillWidth();
        return (y == this.getDrillHeight() - 1 || this.hasHeightController && y == this.getDrillHeight() - 2) && x == (this.getDrillWidth() - 1) / 2;
    }

    private void swapActiveness(int id) {
        this.initDisabledData();
        if (!this.isLocked(id)) {
            int n;
            short[] isDisabled = this.isDisabled;
            int n2 = n = id / 16;
            isDisabled[n2] = (short)(isDisabled[n2] ^ (short)(1 << id % 16));
        }
    }

    private int[] getSettingRect(int x, int y) {
        return new int[]{15 + x * 10, 20 + y * 10, 8, 8};
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        int w = this.getDrillWidth();
        int h = this.getDrillHeight();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int[] rect = this.getSettingRect(i, j);
                String str = this.isLocked(j * w + i) ? Localization.MODULES.ADDONS.LOCKED.translate(new String[0]) : Localization.MODULES.ADDONS.CHANGE_INTELLIGENCE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.CURRENT_INTELLIGENCE.translate(this.isActive(j * w + i) ? "0" : "1");
                this.drawStringOnMouseOver(gui, str, x, y, rect);
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        int maxDrillWidth = 9;
        int maxDrillHeight = 9;
        return (int)Math.ceil(6.1875);
    }

    @Override
    protected void checkGuiData(Object[] info) {
        if (this.isDisabled != null) {
            for (int i = 0; i < this.isDisabled.length; ++i) {
                this.updateGuiData(info, i, this.isDisabled[i]);
            }
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        this.initDisabledData();
        if (id >= 0 && id < this.isDisabled.length) {
            this.isDisabled[id] = data;
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.swapActiveness(data[0]);
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        this.initDisabledData();
        for (int i = 0; i < this.isDisabled.length; ++i) {
            tagCompound.func_74777_a(this.generateNBTName("isDisabled" + i, id), this.isDisabled[i]);
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.initDisabledData();
        for (int i = 0; i < this.isDisabled.length; ++i) {
            this.isDisabled[i] = tagCompound.func_74765_d(this.generateNBTName("isDisabled" + i, id));
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (button == -1 && this.clicked) {
            int w = this.getDrillWidth();
            int h = this.getDrillHeight();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int[] rect;
                    if (this.lastId == j * w + i || this.isActive(j * w + i) != this.clickedState || !this.inRect(x, y, rect = this.getSettingRect(i, j))) continue;
                    this.lastId = j * w + i;
                    this.sendPacket(0, (byte)(j * w + i));
                    return;
                }
            }
        }
        if (button == 0) {
            this.clicked = false;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            int w = this.getDrillWidth();
            int h = this.getDrillHeight();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int[] rect = this.getSettingRect(i, j);
                    if (!this.inRect(x, y, rect)) continue;
                    this.clicked = true;
                    this.clickedState = this.isActive(j * w + i);
                    this.lastId = j * w + i;
                    this.sendPacket(0, (byte)(j * w + i));
                    return;
                }
            }
        }
    }
}

