/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.CartVersion;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.data.ModuleData;

public class ItemCarts
extends ItemMinecart {
    public ItemCarts() {
        super(EntityMinecart.Type.RIDEABLE);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(null);
    }

    public String getName() {
        return "Modular cart";
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        CartVersion.updateItemStack(stack);
        if (!world.field_72995_K && BlockRailBase.func_176562_d((World)world, (BlockPos)pos)) {
            block8: {
                try {
                    NBTTagCompound info = stack.func_77978_p();
                    if (info == null || info.func_74764_b("maxTime")) break block8;
                    try {
                        EntityMinecartModular cart = new EntityMinecartModular(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, info, stack.func_82833_r());
                        world.func_72838_d((Entity)cart);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        player.func_145747_a((ITextComponent)new TextComponentString("The cart failed to be placed into the world, this is due to an issue with one or more modules. Please post your log on the issue tracker here: " + TextFormatting.BLUE + " https://github.com/modmuss50/SC2/issues"));
                        StevesCarts.logger.error(" --------------- Broken cart info --------------- ");
                        StevesCarts.logger.error((Object)info);
                        NBTTagByteArray moduleIDTag = (NBTTagByteArray)info.func_74781_a("Modules");
                        for (byte id : moduleIDTag.func_150292_c()) {
                            try {
                                Class<? extends ModuleBase> moduleClass = ModuleData.getList().get(id).getModuleClass();
                                StevesCarts.logger.error("--- " + moduleClass.getCanonicalName());
                            }
                            catch (Exception ex) {
                                StevesCarts.logger.error("Failed to load module with ID " + id + "! More info below.");
                                e.printStackTrace();
                            }
                        }
                        StevesCarts.logger.error(" --------------- Broken cart info --------------- ");
                        return EnumActionResult.FAIL;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return EnumActionResult.FAIL;
                }
            }
            --stack.field_77994_a;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean useExtraInfo) {
        CartVersion.updateItemStack(item);
        NBTTagCompound info = item.func_77978_p();
        if (info != null) {
            NBTTagByteArray moduleIDTag = (NBTTagByteArray)info.func_74781_a("Modules");
            byte[] bytes = moduleIDTag.func_150292_c();
            ArrayList<ModuleCountPair> counts = new ArrayList<ModuleCountPair>();
            for (int i = 0; i < bytes.length; ++i) {
                byte id = bytes[i];
                ModuleData module = ModuleData.getList().get(id);
                if (module == null) continue;
                boolean found = false;
                if (!info.func_74764_b("Data" + i)) {
                    for (ModuleCountPair count : counts) {
                        if (!count.isContainingData(module)) continue;
                        count.increase();
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                ModuleCountPair count2 = new ModuleCountPair(module);
                if (info.func_74764_b("Data" + i)) {
                    count2.setExtraData(info.func_74771_c("Data" + i));
                }
                counts.add(count2);
            }
            for (ModuleCountPair count3 : counts) {
                list.add(count3.toString());
            }
            if (info.func_74764_b("Spares")) {
                byte[] spares = info.func_74770_j("Spares");
                for (int j = 0; j < spares.length; ++j) {
                    byte id2 = spares[j];
                    ModuleData module2 = ModuleData.getList().get(id2);
                    if (module2 == null) continue;
                    String name = module2.getName();
                    if (info.func_74764_b("Data" + (bytes.length + j))) {
                        name = module2.getCartInfoText(name, info.func_74771_c("Data" + (bytes.length + j)));
                    }
                    list.add(TextFormatting.GOLD + name);
                }
            }
            if (info.func_74764_b("maxTime")) {
                list.add(TextFormatting.RED + "Incomplete cart!");
                int maxTime = info.func_74762_e("maxTime");
                int currentTime = info.func_74762_e("currentTime");
                int timeLeft = maxTime - currentTime;
                list.add(TextFormatting.RED + "Time left: " + this.formatTime(timeLeft));
            }
        } else {
            list.add("No modules loaded");
        }
    }

    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        ticks -= seconds * 20;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d", hours, minutes -= hours * 60, seconds);
    }

    public boolean func_77651_p() {
        return true;
    }
}

