/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.DetectorType;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.LogicObject;

public class OperatorObject {
    private static HashMap<Byte, OperatorObject> allOperators = new HashMap();
    private byte ID;
    private Localization.GUI.DETECTOR name;
    private int childs;

    public static Collection<OperatorObject> getOperatorList(DetectorType type) {
        return type.getOperators().values();
    }

    public static HashMap<Byte, OperatorObject> getAllOperators() {
        return allOperators;
    }

    public OperatorObject(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int childs) {
        this.ID = (byte)ID;
        this.name = name;
        this.childs = childs;
        operators.put(this.ID, this);
        allOperators.put(this.ID, this);
    }

    public byte getID() {
        return this.ID;
    }

    public String getName() {
        return this.name.translate(new String[0]);
    }

    public int getChildCount() {
        return this.childs;
    }

    public boolean inTab() {
        return true;
    }

    public boolean isChildValid(OperatorObject child) {
        return true;
    }

    public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
        return false;
    }

    static {
        HashMap<Byte, OperatorObject> operators = new HashMap<Byte, OperatorObject>();
        new OperatorObject((HashMap)operators, 0, Localization.GUI.DETECTOR.OUTPUT, 1){

            @Override
            public boolean inTab() {
                return false;
            }

            @Override
            public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 1, Localization.GUI.DETECTOR.AND, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) && B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 2, Localization.GUI.DETECTOR.OR, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) || B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 3, Localization.GUI.DETECTOR.NOT, 1){

            @Override
            public boolean isChildValid(OperatorObject child) {
                return this.getID() != child.ID;
            }

            @Override
            public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return !A.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 4, Localization.GUI.DETECTOR.XOR, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) != B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObjectRedirector(operators, 5, Localization.GUI.DETECTOR.TOP, 0, 1, 0);
        new OperatorObjectRedirector(operators, 6, Localization.GUI.DETECTOR.BOT, 0, -1, 0);
        new OperatorObjectRedirector(operators, 7, Localization.GUI.DETECTOR.NORTH, 0, 0, -1);
        new OperatorObjectRedirector(operators, 8, Localization.GUI.DETECTOR.WEST, -1, 0, 0);
        new OperatorObjectRedirector(operators, 9, Localization.GUI.DETECTOR.SOUTH, 0, 0, 1);
        new OperatorObjectRedirector(operators, 10, Localization.GUI.DETECTOR.EAST, 1, 0, 0);
        for (DetectorType type : DetectorType.values()) {
            type.initOperators(new HashMap<Byte, OperatorObject>(operators));
        }
    }

    public static class OperatorObjectRedstone
    extends OperatorObject {
        private int x;
        private int y;
        private int z;

        public OperatorObjectRedstone(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int x, int y, int z) {
            super(operators, ID, name, 0);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
            int x = this.x + detector.func_174877_v().func_177958_n();
            int y = this.y + detector.func_174877_v().func_177956_o();
            int z = this.z + detector.func_174877_v().func_177952_p();
            if (this.x == 0 && this.y == 0 && this.z == 0) {
                return detector.func_145831_w().func_175640_z(new BlockPos(x, y, z));
            }
            int direction = this.y > 0 ? 0 : (this.y < 0 ? 1 : (this.x > 0 ? 4 : (this.x < 0 ? 5 : (this.z > 0 ? 2 : 3))));
            return detector.func_145831_w().func_175651_c(new BlockPos(x, y, z), EnumFacing.func_82600_a((int)direction)) > 0;
        }
    }

    public static class OperatorObjectRedirector
    extends OperatorObject {
        private int x;
        private int y;
        private int z;

        public OperatorObjectRedirector(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int x, int y, int z) {
            super(operators, ID, name, 0);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean evaluate(TileEntityDetector detector, EntityMinecartModular cart, int depth, LogicObject A, LogicObject B) {
            int x = this.x + detector.func_174877_v().func_177958_n();
            int y = this.y + detector.func_174877_v().func_177956_o();
            int z = this.z + detector.func_174877_v().func_177952_p();
            TileEntity tileentity = detector.func_145831_w().func_175625_s(new BlockPos(x, y, z));
            return tileentity != null && tileentity instanceof TileEntityDetector && ((TileEntityDetector)tileentity).evaluate(cart, depth);
        }
    }
}

