/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

@SideOnly(value=Side.CLIENT)
public class GuiActivator
extends GuiBase {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/activator.png");
    TileEntityActivator activator;
    InventoryPlayer invPlayer;

    public GuiActivator(InventoryPlayer invPlayer, TileEntityActivator activator) {
        super(new ContainerActivator((IInventory)invPlayer, activator));
        this.invPlayer = invPlayer;
        this.setXSize(255);
        this.setYSize(222);
        this.activator = activator;
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        int[] box;
        ActivatorOption option;
        int i;
        GL11.glDisable((int)2896);
        this.getFontRenderer().func_78276_b(Localization.GUI.TOGGLER.TITLE.translate(new String[0]), 8, 6, 0x404040);
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            this.getFontRenderer().func_78276_b(option.getName(), box[0] + box[2] + 6, box[1] + 4, 0x404040);
        }
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            this.drawMouseMover(option.getInfo(), x, y, box);
        }
        GL11.glEnable((int)2896);
    }

    private void drawMouseMover(String str, int x, int y, int[] rect) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            this.drawMouseOver(str, x - this.getGuiLeft(), y - this.getGuiTop());
        }
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(texture);
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            ActivatorOption option = this.activator.getOptions().get(i);
            int[] box = this.getBoxRect(i);
            int srcX = 0;
            if (this.inRect(x, y, box)) {
                srcX = 16;
            }
            this.func_73729_b(j + box[0], k + box[1], srcX, this.field_147000_g, box[2], box[3]);
            this.func_73729_b(j + box[0] + 1, k + box[1] + 1, (box[2] - 2) * option.getOption(), this.field_147000_g + box[3], box[2] - 2, box[3] - 2);
        }
    }

    private int[] getBoxRect(int i) {
        return new int[]{20, 22 + i * 20, 16, 16};
    }

    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            int[] box = this.getBoxRect(i);
            if (!this.inRect(x, y, box)) continue;
            byte data = (byte)(button != 0 ? 1 : 0);
            data = (byte)(data | (byte)(i << 1));
            PacketHandler.sendPacket(0, new byte[]{data});
        }
    }
}

