/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vswe.stevescarts.blocks.BlockActivator;
import vswe.stevescarts.blocks.BlockCargoManager;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.BlockDetector;
import vswe.stevescarts.blocks.BlockDistributor;
import vswe.stevescarts.blocks.BlockLiquidManager;
import vswe.stevescarts.blocks.BlockMetalStorage;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.blocks.BlockRailJunction;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.RecipeHelper;
import vswe.stevescarts.items.ItemBlockDetector;
import vswe.stevescarts.items.ItemBlockStorage;
import vswe.stevescarts.items.ItemUpgrade;
import vswe.stevescarts.items.ModItems;

public enum ModBlocks {
    CARGO_MANAGER("BlockCargoManager", BlockCargoManager.class, TileEntityCargo.class, "cargo"),
    JUNCTION("BlockJunction", BlockRailJunction.class),
    ADVANCED_DETECTOR("BlockAdvDetector", BlockRailAdvDetector.class),
    CART_ASSEMBLER("BlockCartAssembler", BlockCartAssembler.class, TileEntityCartAssembler.class, "assembler"),
    MODULE_TOGGLER("BlockActivator", BlockActivator.class, TileEntityActivator.class, "activator"),
    EXTERNAL_DISTRIBUTOR("BlockDistributor", BlockDistributor.class, TileEntityDistributor.class, "distributor"),
    DETECTOR_UNIT("BlockDetector", BlockDetector.class, TileEntityDetector.class, "detector", ItemBlockDetector.class),
    UPGRADE("upgrade", BlockUpgrade.class, TileEntityUpgrade.class, "upgrade", ItemUpgrade.class),
    LIQUID_MANAGER("BlockLiquidManager", BlockLiquidManager.class, TileEntityLiquid.class, "liquid"),
    STORAGE("BlockMetalStorage", BlockMetalStorage.class, ItemBlockStorage.class);

    private final String name;
    private final Class<? extends Block> clazz;
    private final Class<? extends TileEntity> tileEntityClazz;
    private final String tileEntityName;
    private final Class<? extends ItemBlock> itemClazz;
    private Block block;

    private ModBlocks(String name, Class<? extends Block> clazz) {
        this(name, clazz, null, null);
    }

    private ModBlocks(String name, Class<? extends Block> clazz, Class<? extends TileEntity> tileEntityClazz, String tileEntityName) {
        this(name, clazz, tileEntityClazz, tileEntityName, ItemBlock.class);
    }

    private ModBlocks(String name, Class<? extends Block> clazz, Class<? extends ItemBlock> itemClazz) {
        this(name, clazz, null, null, itemClazz);
    }

    private ModBlocks(String name, Class<? extends Block> clazz, Class<? extends TileEntity> tileEntityClazz, String tileEntityName, Class<? extends ItemBlock> itemClazz) {
        this.name = name;
        this.clazz = clazz;
        this.tileEntityClazz = tileEntityClazz;
        this.tileEntityName = tileEntityName;
        this.itemClazz = itemClazz;
    }

    public static void init() {
        for (ModBlocks blockInfo : ModBlocks.values()) {
            try {
                if (Block.class.isAssignableFrom(blockInfo.clazz)) {
                    Block blockInstance;
                    Constructor<? extends Block> blockConstructor = blockInfo.clazz.getConstructor(new Class[0]);
                    Block blockBase = blockInstance = blockConstructor.newInstance(new Object[0]);
                    Block block = blockInstance;
                    block.func_149711_c(2.0f);
                    GameRegistry.registerBlock((Block)block, blockInfo.itemClazz, (String)blockInfo.name);
                    blockBase.func_149663_c("SC2:" + blockInfo.name);
                    blockInfo.block = block;
                    if (blockInfo.tileEntityClazz == null) continue;
                    GameRegistry.registerTileEntity(blockInfo.tileEntityClazz, (String)blockInfo.tileEntityName);
                    continue;
                }
                System.out.println("This is not a block (" + blockInfo.name + ")");
            }
            catch (Exception e) {
                System.out.println("Failed to create block (" + blockInfo.name + ")");
                e.printStackTrace();
            }
        }
        ModBlocks.STORAGE.block.func_149711_c(5.0f).func_149752_b(10.0f);
    }

    public static void addRecipes() {
        String blue = "dyeBlue";
        String orange = "dyeOrange";
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.CARGO_MANAGER.block, 1), new Object[][]{{ComponentTypes.LARGE_IRON_PANE.getItemStack(), ComponentTypes.HUGE_IRON_PANE.getItemStack(), ComponentTypes.LARGE_IRON_PANE.getItemStack()}, {ComponentTypes.HUGE_IRON_PANE.getItemStack(), ComponentTypes.LARGE_DYNAMIC_PANE.getItemStack(), ComponentTypes.HUGE_IRON_PANE.getItemStack()}, {ComponentTypes.LARGE_IRON_PANE.getItemStack(), ComponentTypes.HUGE_IRON_PANE.getItemStack(), ComponentTypes.LARGE_IRON_PANE.getItemStack()}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.MODULE_TOGGLER.block, 1), new Object[][]{{"dyeOrange", Items.field_151043_k, "dyeBlue"}, {Blocks.field_150348_b, Items.field_151042_j, Blocks.field_150348_b}, {Items.field_151137_ax, ComponentTypes.ADVANCED_PCB.getItemStack(), Items.field_151137_ax}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.EXTERNAL_DISTRIBUTOR.block, 1), new Object[][]{{Blocks.field_150348_b, ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150348_b}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151137_ax, ComponentTypes.SIMPLE_PCB.getItemStack()}, {Blocks.field_150348_b, ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150348_b}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.CART_ASSEMBLER.block, 1), new Object[][]{{Items.field_151042_j, Blocks.field_150348_b, Items.field_151042_j}, {Blocks.field_150348_b, Items.field_151042_j, Blocks.field_150348_b}, {ComponentTypes.SIMPLE_PCB.getItemStack(), Blocks.field_150348_b, ComponentTypes.SIMPLE_PCB.getItemStack()}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.JUNCTION.block, 1), new Object[][]{{null, Items.field_151137_ax, null}, {Items.field_151137_ax, Blocks.field_150448_aq, Items.field_151137_ax}, {null, Items.field_151137_ax, null}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.ADVANCED_DETECTOR.block, 2), new Object[][]{{Items.field_151042_j, Blocks.field_150456_au, Items.field_151042_j}, {Items.field_151042_j, Items.field_151137_ax, Items.field_151042_j}, {Items.field_151042_j, Blocks.field_150456_au, Items.field_151042_j}});
        ItemStack unit = new ItemStack(ModBlocks.DETECTOR_UNIT.block, 1, 1);
        RecipeHelper.addRecipe(unit, new Object[][]{{Blocks.field_150347_e, Blocks.field_150456_au, Blocks.field_150347_e}, {Items.field_151042_j, ComponentTypes.SIMPLE_PCB.getItemStack(), Items.field_151042_j}, {Blocks.field_150347_e, Items.field_151137_ax, Blocks.field_150347_e}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.DETECTOR_UNIT.block, 1, 0), new Object[][]{{ComponentTypes.SIMPLE_PCB.getItemStack()}, {unit}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.DETECTOR_UNIT.block, 1, 2), new Object[][]{{Items.field_151042_j, Items.field_151042_j, Items.field_151042_j}, {null, unit, null}, {null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.DETECTOR_UNIT.block, 1, 3), new Object[][]{{Blocks.field_150429_aA, null, Blocks.field_150429_aA}, {Items.field_151137_ax, unit, Items.field_151137_ax}, {null, ComponentTypes.SIMPLE_PCB.getItemStack(), null}});
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.DETECTOR_UNIT.block, 1, 4), new Object[][]{{Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax}, {Items.field_151137_ax, unit, Items.field_151137_ax}, {Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax}});
        ItemStack advtank = new ItemStack((Item)ModItems.modules, 1, 66);
        RecipeHelper.addRecipe(new ItemStack(ModBlocks.LIQUID_MANAGER.block, 1), new Object[][]{{advtank, Items.field_151042_j, advtank}, {Items.field_151042_j, ComponentTypes.TANK_VALVE, Items.field_151042_j}, {advtank, Items.field_151042_j, advtank}});
    }

    public Block getBlock() {
        return this.block;
    }
}

