/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.helpers.DetectorType;

public class BlockDetector
extends BlockContainerBase {
    public BlockDetector() {
        super(Material.field_151594_q);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
        this.func_180632_j(this.func_176203_a(0));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (DetectorType type : DetectorType.values()) {
            list.add(new ItemStack(item, 1, type.getMeta()));
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)StevesCarts.instance, (int)6, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)DetectorType.POWERED) != false && DetectorType.getTypeFromSate(blockState).shouldEmitRedstone() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        DetectorType type = DetectorType.getTypeFromSate(world.func_180495_p(pos));
        return type.shouldEmitRedstone() || type == DetectorType.REDSTONE;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityDetector();
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = false;
        if (meta > DetectorType.values().length) {
            powered = true;
        }
        return this.func_176223_P().func_177226_a(DetectorType.SATE, (Comparable)((Object)DetectorType.getTypeFromint(meta - (powered ? DetectorType.values().length + 1 : 0)))).func_177226_a((IProperty)DetectorType.POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)DetectorType.POWERED);
        return ((DetectorType)((Object)state.func_177229_b(DetectorType.SATE))).getMeta() + (powered ? DetectorType.values().length + 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DetectorType.SATE, DetectorType.POWERED});
    }
}

