/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.textures;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.Log;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.client.ClientSide;
import mod.flatcoloredblocks.textures.AlphaModifiedTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TextureGenerator {
    private final Map<Integer, TextureAtlasSprite> generatedTransparentTexture = new HashMap<Integer, TextureAtlasSprite>();
    private TextureAtlasSprite glowingTexture;

    @SubscribeEvent
    void registerTransparentTextures(TextureStitchEvent.Pre ev) {
        try {
            ResourceLocation sourceLoc = ClientSide.instance.getTextureResourceLocation(EnumFlatBlockType.TRANSPARENT);
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(sourceLoc);
            BufferedImage bi = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            for (int varient : FlatColoredBlocks.instance.transparent.shadeConvertVariant) {
                String name = ClientSide.instance.getTextureName(EnumFlatBlockType.TRANSPARENT, varient);
                TextureAtlasSprite out = AlphaModifiedTexture.generate(name, bi, (float)varient / 255.0f, ev.getMap());
                this.generatedTransparentTexture.put(varient, out);
            }
        }
        catch (IOException e) {
            Log.logError("Unable to load Base Texture", e);
            TextureAtlasSprite out = ev.getMap().func_174942_a(new ResourceLocation(ClientSide.instance.getBaseTextureNameWithBlocks(EnumFlatBlockType.TRANSPARENT)));
            for (int varient : FlatColoredBlocks.instance.transparent.shadeConvertVariant) {
                this.generatedTransparentTexture.put(varient, out);
            }
        }
        if (!FlatColoredBlocks.instance.config.GLOWING_EMITS_LIGHT) {
            this.glowingTexture = ev.getMap().func_174942_a(new ResourceLocation(ClientSide.instance.getBaseTextureNameWithBlocks(EnumFlatBlockType.GLOWING)));
        }
    }

    public TextureAtlasSprite getGlowingTexture(int varient) {
        return this.glowingTexture;
    }

    public TextureAtlasSprite getTransparentTexture(int varient) {
        return this.generatedTransparentTexture.get(varient);
    }
}

